/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.taming;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;

public class TamingHealthBoost
extends SimpleAdaptation<Config> {
    private final UUID attUUID = UUID.nameUUIDFromBytes("health-boost".getBytes());
    private final String attid = "att-health-boost";

    public TamingHealthBoost() {
        super("tame-health");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("taming", "health", "description"));
        this.setDisplayName(Localizer.dLocalize("taming", "health", "name"));
        this.setIcon(Material.COOKED_BEEF);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4753L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getHealthBoost(level), 0) + C.GRAY + " " + Localizer.dLocalize("taming", "health", "lore1"));
    }

    private double getHealthBoost(int level) {
        return this.getLevelPercent(level) * ((Config)this.getConfig()).healthBoostFactor + ((Config)this.getConfig()).healthBoostBase;
    }

    @Override
    public void onTick() {
        for (World i : Bukkit.getServer().getWorlds()) {
            J.s(() -> {
                Collection gl = i.getEntitiesByClass(Tameable.class);
                J.a(() -> {
                    for (Tameable j : gl) {
                        if (!j.isTamed() || !(j.getOwner() instanceof Player)) continue;
                        Player p = (Player)j.getOwner();
                        this.update(j, this.getLevel(p));
                    }
                });
            });
        }
    }

    private void update(Tameable j, int level) {
        AttributeModifier mod = new AttributeModifier(this.attUUID, "att-health-boost", this.getHealthBoost(level), AttributeModifier.Operation.ADD_SCALAR);
        j.getAttribute(Attribute.GENERIC_MAX_HEALTH).removeModifier(mod);
        if (level > 0) {
            j.getAttribute(Attribute.GENERIC_MAX_HEALTH).addModifier(mod);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 3;
        double costFactor = 0.4;
        double healthBoostFactor = 2.5;
        double healthBoostBase = 0.57;

        static {
            IBootstrap.dasBoot();
        }
    }
}

