/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class TragoulGlobe
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public TragoulGlobe() {
        super("tragoul-globe");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "globe", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "globe", "name"));
        this.setIcon(Material.ENDER_PEARL);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("tragoul", "globe", "lore1"));
        v.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "globe", "lore2") + (((Config)this.getConfig()).rangePerLevel * (double)level + ((Config)this.getConfig()).initalRange));
        v.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "globe", "lore3") + ((Config)this.getConfig()).bonusDamagePerLevel * (double)level);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        Entity entity2 = e.getDamager();
        if (entity2 instanceof Player && this.hasAdaptation(p = (Player)entity2)) {
            if (this.cooldowns.containsKey(p)) {
                if ((double)this.cooldowns.get(p).longValue() + 1000.0 * ((Config)this.getConfig()).cooldown > (double)System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            this.cooldowns.put(p, System.currentTimeMillis());
            double range = ((Config)this.getConfig()).rangePerLevel * (double)this.getLevel(p) + ((Config)this.getConfig()).initalRange;
            List<Entity> entitiesInRange = p.getNearbyEntities(range, range, range).stream().filter(entity -> entity instanceof LivingEntity && !entity.equals(p)).toList();
            if (entitiesInRange.size() <= 1) {
                return;
            }
            double damagePerEntity = e.getDamage() / (double)entitiesInRange.size() + ((Config)this.getConfig()).bonusDamagePerLevel * (double)this.getLevel(p);
            e.setDamage(damagePerEntity);
            for (Entity entity3 : entitiesInRange) {
                ((LivingEntity)entity3).damage(damagePerEntity, (Entity)p);
            }
            if (((Config)this.getConfig()).showParticles) {
                J.s(() -> {
                    if (((Config)this.getConfig()).showParticles) {
                        this.vfxFastSphere(p.getLocation(), range, Color.BLACK, 400);
                        this.vfxLoadingRing(p.getLocation(), range, Particle.DRIP_LAVA, 5, 350);
                    }
                });
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        double cooldown = 1.0;
        double rangePerLevel = 3.0;
        double initalRange = 5.0;
        double costFactor = 1.1;
        double bonusDamagePerLevel = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

