/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class TragoulHealing
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;
    private final Map<Player, Long> healingWindow;

    public TragoulHealing() {
        super("tragoul-healing");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "healing", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "healing", "name"));
        this.setIcon(Material.REDSTONE);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
        this.healingWindow = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("tragoul", "healing", "lore1"));
        v.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "healing", "lore2"));
        v.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "healing", "lore3") + (((Config)this.getConfig()).minHealPercent + (((Config)this.getConfig()).maxHealPercent - ((Config)this.getConfig()).minHealPercent) * (double)(level - 1) / (double)(((Config)this.getConfig()).maxLevel - 1)) + "%");
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity = e.getDamager();
        if (entity instanceof Player && this.hasAdaptation(p = (Player)entity)) {
            if (this.isOnCooldown(p)) {
                return;
            }
            if (!this.healingWindow.containsKey(p)) {
                Adapt.verbose("Starting healing window for " + p.getName());
                this.startHealingWindow(p);
            }
            if (((Config)this.getConfig()).showParticles) {
                this.vfxParticleLine(p.getLocation(), e.getEntity().getLocation(), 25, Particle.WHITE_ASH);
            }
            double healPercentage = ((Config)this.getConfig()).minHealPercent + (((Config)this.getConfig()).maxHealPercent - ((Config)this.getConfig()).minHealPercent) * (double)(this.getLevel(p) - 1) / (double)(((Config)this.getConfig()).maxLevel - 1);
            double healAmount = e.getDamage() * healPercentage;
            Adapt.verbose("Healing " + p.getName() + " for " + healAmount + " (" + healPercentage * 100.0 + "% of " + e.getDamage() + " damage)");
            p.setHealth(Math.min(p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), p.getHealth() + healAmount));
        }
    }

    private boolean isOnCooldown(Player p) {
        return this.cooldowns.containsKey(p) && this.cooldowns.get(p).compareTo(System.currentTimeMillis()) > 0;
    }

    private void startHealingWindow(Player p) {
        long currentTime = System.currentTimeMillis();
        this.healingWindow.put(p, currentTime + (long)((Config)this.getConfig()).windowDuration);
        Bukkit.getScheduler().runTaskLater((Plugin)Adapt.instance, () -> {
            this.healingWindow.remove(p);
            this.cooldowns.put(p, currentTime + (long)((Config)this.getConfig()).windowDuration + (long)((Config)this.getConfig()).cooldownDuration);
        }, (long)(((Config)this.getConfig()).windowDuration / 50));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        double costFactor = 1.1;
        double minHealPercent = 0.1;
        double maxHealPercent = 0.45;
        int cooldownDuration = 1000;
        int windowDuration = 3000;

        static {
            IBootstrap.dasBoot();
        }
    }
}

