/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class TragoulLance
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public TragoulLance() {
        super("tragoul-lance");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "lance", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "lance", "name"));
        this.setIcon(Material.TRIDENT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeath(EntityDeathEvent event) {
        Player p;
        EntityDamageByEntityEvent e;
        Entity entity;
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent && (entity = (e = (EntityDamageByEntityEvent)entityDamageEvent).getDamager()) instanceof Player && this.hasAdaptation(p = (Player)entity)) {
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p) + 5000L > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            this.cooldowns.put(p, System.currentTimeMillis());
            int level = this.getLevel(p);
            double baseSeekerRange = 5 + 4 * level;
            double damageDealt = e.getDamage();
            double seekerDamage = ((Config)this.getConfig()).seekerDamageMultiplier * damageDealt;
            this.triggerSeeker(p, (Entity)event.getEntity(), seekerDamage, level, baseSeekerRange);
        }
    }

    private void triggerSeeker(Player p, Entity origin, double damage, int remainingSeekers, double range) {
        if (remainingSeekers <= 0) {
            return;
        }
        LivingEntity nearest = null;
        double minDistance = range;
        for (Entity e : origin.getNearbyEntities(range, range, range)) {
            double distance;
            LivingEntity le;
            if (!(e instanceof LivingEntity) || (le = (LivingEntity)e) == p || !((distance = origin.getLocation().distance(le.getLocation())) < minDistance)) continue;
            nearest = le;
            minDistance = distance;
        }
        if (nearest != null) {
            this.vfxMovingSphere(origin.getLocation(), nearest.getLocation(), ((Config)this.getConfig()).seekerDelay, Color.MAROON, 0.25, 4.0);
            double seekerDamage = ((Config)this.getConfig()).seekerDamageMultiplier * damage;
            double selfDamage = ((Config)this.getConfig()).selfDamageMultiplier * seekerDamage;
            Adapt.verbose("Seeker damage: " + seekerDamage + " Self damage: " + selfDamage);
            p.damage(selfDamage, (Entity)p);
            LivingEntity finalNearest = nearest;
            Bukkit.getScheduler().runTaskLater((Plugin)Adapt.instance, () -> {
                double remainingHealth = finalNearest.getHealth() - damage;
                finalNearest.damage(damage, (Entity)p);
                if (remainingHealth <= 0.0) {
                    this.triggerSeeker(p, (Entity)finalNearest, damage * 0.5, remainingSeekers - 1, range);
                }
            }, (long)((Config)this.getConfig()).seekerDelay);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("tragoul", "lance", "lore1"));
        v.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "lance", "lore2"));
        v.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "lance", "lore3") + level);
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        int seekerDelay = 20;
        double costFactor = 1.1;
        double seekerDamageMultiplier = 0.5;
        double selfDamageMultiplier = 0.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

