/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.unarmed;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class UnarmedPower
extends SimpleAdaptation<Config> {
    public UnarmedPower() {
        super("unarmed-power");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("unarmed", "power", "description"));
        this.setDisplayName(Localizer.dLocalize("unarmed", "power", "name"));
        this.setIcon(Material.LEATHER_HELMET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(4444L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getUnarmedDamage(level), 0) + C.GRAY + Localizer.dLocalize("unarmed", "power", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (!this.hasAdaptation(p)) {
                return;
            }
            if (p.getInventory().getItemInMainHand().getType() != Material.AIR && p.getInventory().getItemInOffHand().getType() != Material.AIR) {
                return;
            }
            double factor = this.getLevelPercent(p);
            if (factor <= 0.0) {
                return;
            }
            e.setDamage(e.getDamage() * (1.0 + this.getUnarmedDamage(this.getLevel(p))));
            this.getSkill().xp(p, 0.321 * factor * e.getDamage());
        }
    }

    private double getUnarmedDamage(int level) {
        return this.getLevelPercent(level) * ((Config)this.getConfig()).damageFactor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 7;
        int initialCost = 6;
        double costFactor = 0.425;
        double damageFactor = 2.57;

        static {
            IBootstrap.dasBoot();
        }
    }
}

