/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.unarmed;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class UnarmedSuckerPunch
extends SimpleAdaptation<Config> {
    public UnarmedSuckerPunch() {
        super("unarmed-sucker-punch");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("unarmed", "suckerpunch", "description"));
        this.setDisplayName(Localizer.dLocalize("unarmed", "suckerpunch", "name"));
        this.setIcon(Material.OBSIDIAN);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(4944L);
    }

    @Override
    public void addStats(int level, Element v) {
        double f = this.getLevelPercent(level);
        double d = this.getDamage(f);
        v.addLore(C.GREEN + "+ " + Form.pc(d, 0) + C.GRAY + " " + Localizer.dLocalize("unarmed", "suckerpunch", "lore1"));
        v.addLore(C.GRAY + Localizer.dLocalize("unarmed", "suckerpunch", "lore2"));
    }

    private double getDamage(double f) {
        return ((Config)this.getConfig()).baseDamage + f * ((Config)this.getConfig()).damageFactor;
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (!this.hasAdaptation(p)) {
                return;
            }
            if (p.getInventory().getItemInMainHand().getType() != Material.AIR && p.getInventory().getItemInOffHand().getType() != Material.AIR) {
                return;
            }
            double factor = this.getLevelPercent(p);
            if (!p.isSprinting()) {
                return;
            }
            if (factor <= 0.0) {
                return;
            }
            if (this.isTool(p.getInventory().getItemInMainHand())) {
                return;
            }
            e.setDamage(e.getDamage() * this.getDamage(factor));
            e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_PLAYER_ATTACK_STRONG, 1.0f, 1.8f);
            e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.BLOCK_BASALT_BREAK, 1.0f, 0.6f);
            this.getSkill().xp(p, 6.221 * e.getDamage());
            if (e.getDamage() > 5.0) {
                this.getSkill().xp(p, 0.42 * e.getDamage());
                if (((Config)this.getConfig()).showParticles) {
                    e.getEntity().getWorld().spawnParticle(Particle.FLASH, e.getEntity().getLocation(), 1);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        int initialCost = 4;
        double costFactor = 0.225;
        double baseDamage = 0.2;
        double damageFactor = 0.55;

        static {
            IBootstrap.dasBoot();
        }
    }
}

