/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.block;

import com.volmit.adapt.util.arcane.spatial.matter.slices.RawMatter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public class ScaffoldMatter
extends RawMatter<ScaffoldData> {
    public ScaffoldMatter(int width, int height, int depth) {
        super(width, height, depth, ScaffoldData.class);
    }

    @Override
    public void writeNode(ScaffoldData scaffoldData, DataOutputStream dos) throws IOException {
        dos.writeLong(scaffoldData.getUuid().getMostSignificantBits());
        dos.writeLong(scaffoldData.getUuid().getLeastSignificantBits());
        dos.writeLong(scaffoldData.getTime());
    }

    @Override
    public ScaffoldData readNode(DataInputStream din) throws IOException {
        return ScaffoldData.builder().uuid(new UUID(din.readLong(), din.readLong())).time(din.readLong()).build();
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class ScaffoldData {
        private UUID uuid;
        private long time;

        private static long $default$time() {
            return 0L;
        }

        public static ScaffoldDataBuilder builder() {
            return new ScaffoldDataBuilder();
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public long getTime() {
            return this.time;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScaffoldData)) {
                return false;
            }
            ScaffoldData other = (ScaffoldData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            return !(this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScaffoldData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            return result;
        }

        public String toString() {
            return "ScaffoldMatter.ScaffoldData(uuid=" + this.getUuid() + ", time=" + this.getTime() + ")";
        }

        public ScaffoldData(UUID uuid, long time) {
            this.uuid = uuid;
            this.time = time;
        }

        public ScaffoldData() {
            this.time = ScaffoldData.$default$time();
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class ScaffoldDataBuilder {
            private UUID uuid;
            private boolean time$set;
            private long time$value;

            ScaffoldDataBuilder() {
            }

            public ScaffoldDataBuilder uuid(UUID uuid) {
                this.uuid = uuid;
                return this;
            }

            public ScaffoldDataBuilder time(long time) {
                this.time$value = time;
                this.time$set = true;
                return this;
            }

            public ScaffoldData build() {
                long time$value = this.time$value;
                if (!this.time$set) {
                    time$value = ScaffoldData.$default$time();
                }
                return new ScaffoldData(this.uuid, time$value);
            }

            public String toString() {
                return "ScaffoldMatter.ScaffoldData.ScaffoldDataBuilder(uuid=" + this.uuid + ", time$value=" + this.time$value + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }
}

