/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.item.DataItem;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BoundRedstoneTorch
implements DataItem<Data> {
    public static BoundRedstoneTorch io;

    public static Location getLocation(ItemStack stack) {
        if (io.getData(stack) != null) {
            return ((Data)io.getData(stack)).getLocation();
        }
        return null;
    }

    public static void setData(ItemStack item, Location t) {
        io.setData(item, new Data(t));
    }

    public static ItemStack withData(Location t) {
        return io.withData(new Data(t));
    }

    public static boolean isBindableItem(ItemStack t) {
        if (t.getType().equals((Object)Material.REDSTONE_TORCH) && t.getItemMeta() != null && t.getItemMeta().getLore() != null && ((String)t.getItemMeta().getLore().get(0)).contains(Localizer.dLocalize("items", "boundredstonetorch", "name"))) {
            Adapt.verbose("Torch is bindable: " + t.getType().name());
            return true;
        }
        return false;
    }

    @Override
    public Material getMaterial() {
        return Material.REDSTONE_TORCH;
    }

    @Override
    public Class<Data> getType() {
        return Data.class;
    }

    @Override
    public void applyLore(Data data, List<String> lore) {
        lore.add(C.WHITE + Localizer.dLocalize("items", "boundredstonetorch", "name"));
        lore.add(C.GRAY + Localizer.dLocalize("items", "boundredstonetorch", "usage1"));
        lore.add(C.GRAY + Localizer.dLocalize("items", "boundredstonetorch", "usage2"));
    }

    @Override
    public void applyMeta(Data data, ItemMeta meta) {
        meta.addEnchant(Enchantment.BINDING_CURSE, 10, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_DYE});
        meta.setDisplayName(Localizer.dLocalize("items", "boundredstonetorch", "name"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundRedstoneTorch)) {
            return false;
        }
        BoundRedstoneTorch other = (BoundRedstoneTorch)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundRedstoneTorch;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BoundRedstoneTorch()";
    }

    static {
        IBootstrap.dasBoot();
        io = new BoundRedstoneTorch();
    }

    public static class Data {
        private Location location;

        public static Data at(Location l) {
            return new Data(l);
        }

        public Data(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Location this$location = this.getLocation();
            Location other$location = other.getLocation();
            return !(this$location == null ? other$location != null : !this$location.equals(other$location));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Location $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            return result;
        }

        public String toString() {
            return "BoundRedstoneTorch.Data(location=" + this.getLocation() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

