/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.item.DataItem;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BoundSnowBall
implements DataItem<Data> {
    public static BoundSnowBall io;

    public static Player getPlayer(ItemStack stack) {
        if (io.getData(stack) != null) {
            return ((Data)io.getData(stack)).getPlayer();
        }
        return null;
    }

    public static void setData(ItemStack item, Player t) {
        io.setData(item, new Data(t));
    }

    public static ItemStack withData(Player t) {
        return io.withData(new Data(t));
    }

    public static boolean isBindableItem(ItemStack t) {
        if (t.getType().equals((Object)Material.SNOWBALL) && t.getItemMeta() != null && t.getItemMeta().getLore() != null && ((String)t.getItemMeta().getLore().get(0)).contains(Localizer.dLocalize("items", "boundsnowball", "name"))) {
            Adapt.verbose("Snowball is bindable: " + t.getType().name());
            return true;
        }
        return false;
    }

    @Override
    public Material getMaterial() {
        return Material.SNOWBALL;
    }

    @Override
    public Class<Data> getType() {
        return Data.class;
    }

    @Override
    public void applyLore(Data data, List<String> lore) {
        lore.add(C.WHITE + Localizer.dLocalize("items", "boundsnowball", "name"));
        lore.add(C.GRAY + Localizer.dLocalize("items", "boundsnowball", "usage1"));
    }

    @Override
    public void applyMeta(Data data, ItemMeta meta) {
        meta.addEnchant(Enchantment.BINDING_CURSE, 10, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_DYE});
        meta.setDisplayName(Localizer.dLocalize("items", "boundsnowball", "name"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundSnowBall)) {
            return false;
        }
        BoundSnowBall other = (BoundSnowBall)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundSnowBall;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BoundSnowBall()";
    }

    static {
        IBootstrap.dasBoot();
        io = new BoundSnowBall();
    }

    public static class Data {
        private Player player;

        public static Data at(Player p) {
            return new Data(p);
        }

        public Data(Player player) {
            this.player = player;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Player this$player = this.getPlayer();
            Player other$player = other.getPlayer();
            return !(this$player == null ? other$player != null : !this$player.equals(other$player));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Player $player = this.getPlayer();
            result = result * 59 + ($player == null ? 43 : $player.hashCode());
            return result;
        }

        public String toString() {
            return "BoundSnowBall.Data(player=" + this.getPlayer() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

