/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.item.DataItem;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KnowledgeOrb
implements DataItem<Data> {
    public static KnowledgeOrb io;

    public static Data get(ItemStack is) {
        return (Data)io.getData(is);
    }

    public static String getSkill(ItemStack stack) {
        if (io.getData(stack) != null) {
            return ((Data)io.getData(stack)).getSkill();
        }
        return null;
    }

    public static long getKnowledge(ItemStack stack) {
        if (io.getData(stack) != null) {
            return ((Data)io.getData(stack)).getKnowledge();
        }
        return 0L;
    }

    public static void set(ItemStack item, String skill, int knowledge) {
        io.setData(item, new Data(skill, knowledge));
    }

    public static ItemStack with(String skill, int knowledge) {
        return io.withData(new Data(skill, knowledge));
    }

    @Override
    public Material getMaterial() {
        return Material.SNOWBALL;
    }

    @Override
    public Class<Data> getType() {
        return Data.class;
    }

    @Override
    public void applyLore(Data data, List<String> lore) {
        lore.add(C.WHITE + Localizer.dLocalize("snippets", "knowledgeorb", "contains") + " " + C.UNDERLINE + C.WHITE + data.knowledge + " " + Localizer.dLocalize("snippets", "knowledgeorb", "knowledge"));
        lore.add(C.LIGHT_PURPLE + Localizer.dLocalize("snippets", "knowledgeorb", "rightclick") + " " + C.GRAY + Localizer.dLocalize("snippets", "knowledgeorb", "togainknowledge"));
    }

    @Override
    public void applyMeta(Data data, ItemMeta meta) {
        meta.addEnchant(Enchantment.BINDING_CURSE, 10, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        meta.setDisplayName(Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(data.skill).getDisplayName() + " " + Localizer.dLocalize("snippets", "knowledgeorb", "knowledgeorb"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnowledgeOrb)) {
            return false;
        }
        KnowledgeOrb other = (KnowledgeOrb)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KnowledgeOrb;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "KnowledgeOrb()";
    }

    static {
        IBootstrap.dasBoot();
        io = new KnowledgeOrb();
    }

    public static class Data {
        private String skill;
        private int knowledge;

        public void apply(Player p) {
            Adapt.instance.getAdaptServer().getPlayer(p).getSkillLine(this.skill).giveKnowledge(this.knowledge);
        }

        public Data(String skill, int knowledge) {
            this.skill = skill;
            this.knowledge = knowledge;
        }

        public String getSkill() {
            return this.skill;
        }

        public int getKnowledge() {
            return this.knowledge;
        }

        public void setSkill(String skill) {
            this.skill = skill;
        }

        public void setKnowledge(int knowledge) {
            this.knowledge = knowledge;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getKnowledge() != other.getKnowledge()) {
                return false;
            }
            String this$skill = this.getSkill();
            String other$skill = other.getSkill();
            return !(this$skill == null ? other$skill != null : !this$skill.equals(other$skill));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getKnowledge();
            String $skill = this.getSkill();
            result = result * 59 + ($skill == null ? 43 : $skill.hashCode());
            return result;
        }

        public String toString() {
            return "KnowledgeOrb.Data(skill=" + this.getSkill() + ", knowledge=" + this.getKnowledge() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

