/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.protector;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.association.DelayedRegionOverlapAssociation;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardProtector
implements Protector {
    private final RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
    private final StateFlag flag = new StateFlag("use-adaptations", false);

    public WorldGuardProtector() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        ConcurrentMap flags = (ConcurrentMap)Curse.on(registry).field("flags").get();
        flags.put(this.flag.getName().toLowerCase(), this.flag);
    }

    @Override
    public boolean checkRegion(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, location, this.flag);
    }

    @Override
    public boolean canBlockBreak(Player player, Location blockLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, blockLocation, adaptation) && this.checkPerm(blockLocation, Flags.BLOCK_BREAK);
    }

    @Override
    public boolean canBlockPlace(Player player, Location blockLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, blockLocation, adaptation) && this.checkPerm(blockLocation, Flags.BLOCK_PLACE);
    }

    @Override
    public boolean canPVP(Player player, Location entityLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, entityLocation, adaptation) && this.checkPerm(entityLocation, Flags.PVP);
    }

    @Override
    public boolean canPVE(Player player, Location entityLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, entityLocation, adaptation) && this.checkPerm(entityLocation, Flags.DAMAGE_ANIMALS);
    }

    @Override
    public boolean canInteract(Player player, Location targetLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, targetLocation, adaptation) && this.checkPerm(targetLocation, Flags.INTERACT);
    }

    @Override
    public boolean canAccessChest(Player player, Location chestLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, chestLocation, adaptation) && this.checkPerm(chestLocation, Flags.CHEST_ACCESS);
    }

    private boolean checkPerm(Location location, StateFlag flag) {
        return this.checkPerm(null, location, flag);
    }

    private boolean checkPerm(Player player, Location location, StateFlag flag) {
        RegionQuery regionQuery = this.container.createQuery();
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)location);
        if (player == null) {
            return regionQuery.queryState(loc, (RegionAssociable)new DelayedRegionOverlapAssociation(regionQuery, loc), new StateFlag[]{flag}) != StateFlag.State.DENY;
        }
        if (!this.hasBypass(player, location)) {
            return regionQuery.queryState(loc, WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{flag}) != StateFlag.State.DENY;
        }
        return true;
    }

    @Override
    public String getName() {
        return "WorldGuard";
    }

    @Override
    public boolean isEnabledByDefault() {
        return AdaptConfig.get().getProtectorSupport().isWorldguard();
    }

    private boolean hasBypass(Player p, Location l) {
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(p);
        World world = BukkitAdapter.adapt((org.bukkit.World)l.getWorld());
        return WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, world);
    }

    static {
        IBootstrap.dasBoot();
    }
}

