/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.architect.ArchitectFoundation;
import com.volmit.adapt.content.adaptation.architect.ArchitectGlass;
import com.volmit.adapt.content.adaptation.architect.ArchitectPlacement;
import com.volmit.adapt.content.adaptation.architect.ArchitectWirelessRedstone;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class SkillArchitect
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillArchitect() {
        super("architect", Localizer.dLocalize("skill", "architect", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.AQUA);
        this.setDescription(Localizer.dLocalize("skill", "architect", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "architect", "name"));
        this.setInterval(3100L);
        this.setIcon(Material.IRON_BARS);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.BRICK).key("challenge_place_1k").title(Localizer.dLocalize("advancement", "challenge_place_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_place_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.BRICK).key("challenge_place_5k").title(Localizer.dLocalize("advancement", "challenge_place_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_place_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHER_BRICK).key("challenge_place_50k").title(Localizer.dLocalize("advancement", "challenge_place_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_place_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHER_BRICK).key("challenge_place_500k").title(Localizer.dLocalize("advancement", "challenge_place_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_place_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_INGOT).key("challenge_place_5m").title(Localizer.dLocalize("advancement", "challenge_place_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_place_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_place_1k").goal(1000.0).stat("blocks.placed").reward(((Config)this.getConfig()).challengePlace1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_place_5k").goal(5000.0).stat("blocks.placed").reward(((Config)this.getConfig()).challengePlace1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_place_50k").goal(50000.0).stat("blocks.placed").reward(((Config)this.getConfig()).challengePlace1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_place_500k").goal(500000.0).stat("blocks.placed").reward(((Config)this.getConfig()).challengePlace1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_place_5m").goal(5000000.0).stat("blocks.placed").reward(((Config)this.getConfig()).challengePlace1kReward).build());
        this.setIcon(Material.SMITHING_TABLE);
        this.registerAdaptation(new ArchitectGlass());
        this.registerAdaptation(new ArchitectFoundation());
        this.registerAdaptation(new ArchitectPlacement());
        this.registerAdaptation(new ArchitectWirelessRedstone());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockPlaceEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (!this.isStorage(e.getBlock().getType().createBlockData())) {
                double v = this.getValue(e.getBlock()) * ((Config)this.getConfig()).xpValueMultiplier;
                AdaptPlayer adaptPlayer = this.getPlayer(p);
                adaptPlayer.getData().addStat("blocks.placed", 1.0);
                adaptPlayer.getData().addStat("blocks.placed.value", v);
                this.handleBlockCooldown(p, () -> {
                    try {
                        J.a(() -> this.xp(p, e.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), this.blockXP(e.getBlock(), ((Config)this.getConfig()).xpBase + v)));
                    }
                    catch (Exception ignored) {
                        Adapt.verbose("Failed to give XP to " + p.getName() + " for placing " + e.getBlock().getType().name());
                    }
                });
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> this.getPlayer(p).getData().addStat("blocks.broken", 1.0));
    }

    @Override
    public void onTick() {
        for (Player i : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(i, () -> this.checkStatTrackers(this.getPlayer(i)));
        }
    }

    private void handleBlockCooldown(Player p, Runnable action) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(p);
        }
        this.cooldowns.put(p, System.currentTimeMillis());
        action.run();
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double challengePlace1kReward = 1750.0;
        double xpValueMultiplier = 1.0;
        long cooldownDelay = 1250L;
        double xpBase = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

