/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.axe.AxeChop;
import com.volmit.adapt.content.adaptation.axe.AxeCraftLogSwap;
import com.volmit.adapt.content.adaptation.axe.AxeDropToInventory;
import com.volmit.adapt.content.adaptation.axe.AxeGroundSmash;
import com.volmit.adapt.content.adaptation.axe.AxeLeafVeinminer;
import com.volmit.adapt.content.adaptation.axe.AxeWoodVeinminer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillAxes
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillAxes() {
        super("axes", Localizer.dLocalize("skill", "axes", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "axes", "description1") + C.ITALIC + Localizer.dLocalize("skill", "axes", "description2") + C.GRAY + " " + Localizer.dLocalize("skill", "axes", "description3"));
        this.setDisplayName(Localizer.dLocalize("skill", "axes", "name"));
        this.setInterval(5251L);
        this.setIcon(Material.GOLDEN_AXE);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new AxeGroundSmash());
        this.registerAdaptation(new AxeChop());
        this.registerAdaptation(new AxeDropToInventory());
        this.registerAdaptation(new AxeLeafVeinminer());
        this.registerAdaptation(new AxeWoodVeinminer());
        this.registerAdaptation(new AxeCraftLogSwap());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.WOODEN_AXE).key("challenge_chop_1k").title(Localizer.dLocalize("advancement", "challenge_chop_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.STONE_AXE).key("challenge_chop_5k").title(Localizer.dLocalize("advancement", "challenge_chop_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_AXE).key("challenge_chop_50k").title(Localizer.dLocalize("advancement", "challenge_chop_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_AXE).key("challenge_chop_500k").title(Localizer.dLocalize("advancement", "challenge_chop_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHERITE_AXE).key("challenge_chop_5m").title(Localizer.dLocalize("advancement", "challenge_chop_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_1k").goal(1000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_5k").goal(5000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_50k").goal(50000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_500k").goal(500000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_5m").goal(5000000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (this.checkValidEntity(e.getEntity().getType())) {
                if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
                    return;
                }
                this.shouldReturnForPlayer(p, () -> {
                    if (e.getEntity().isDead() || e.getEntity().isInvulnerable() || p.isDead() || p.isInvulnerable()) {
                        return;
                    }
                    AdaptPlayer a = this.getPlayer(p);
                    ItemStack hand = a.getPlayer().getInventory().getItemInMainHand();
                    if (this.isAxe(hand)) {
                        this.handleCooldown(p, () -> {
                            a.getData().addStat("axes.swings", 1.0);
                            a.getData().addStat("axes.damage", e.getDamage());
                            this.xp(a.getPlayer(), e.getEntity().getLocation(), ((Config)this.getConfig()).axeDamageXPMultiplier * e.getDamage());
                        });
                    }
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, () -> {
            if (this.isAxe(p.getInventory().getItemInMainHand()) && this.isLog(new ItemStack(e.getBlock().getType()))) {
                double v = this.getValue(e.getBlock().getType());
                AdaptPlayer a = this.getPlayer(p);
                a.getData().addStat("axes.blocks.broken", 1.0);
                a.getData().addStat("axes.blocks.value", this.getValue(e.getBlock().getBlockData()));
                this.handleCooldown(p, () -> this.xp(p, e.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), this.blockXP(e.getBlock(), v)));
            }
        });
    }

    private void handleCooldown(Player p, Runnable action) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(p);
        }
        this.cooldowns.put(p, System.currentTimeMillis());
        action.run();
    }

    @Override
    public double getValue(Material type) {
        double value = super.getValue(type) * ((Config)this.getConfig()).valueXPMultiplier;
        value += Math.min(((Config)this.getConfig()).maxHardnessBonus, (double)type.getHardness());
        value += Math.min(((Config)this.getConfig()).maxBlastResistanceBonus, (double)type.getBlastResistance());
        if (type.name().endsWith("_LOG") || type.name().endsWith("_WOOD")) {
            value += ((Config)this.getConfig()).logOrWoodXPMultiplier;
        }
        if (type.name().endsWith("_LEAVES")) {
            value += ((Config)this.getConfig()).leavesMultiplier;
        }
        if (type.getHardness() == 0.0f) {
            value = 0.0;
        }
        return value;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double maxHardnessBonus = 9.0;
        double maxBlastResistanceBonus = 10.0;
        double challengeChopReward = 1750.0;
        double logOrWoodXPMultiplier = 2.67;
        double leavesMultiplier = 1.11;
        long cooldownDelay = 2250L;
        double valueXPMultiplier = 0.225;
        double axeDamageXPMultiplier = 13.26;

        static {
            IBootstrap.dasBoot();
        }
    }
}

