/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.crafting.CraftingBackpacks;
import com.volmit.adapt.content.adaptation.crafting.CraftingDeconstruction;
import com.volmit.adapt.content.adaptation.crafting.CraftingLeather;
import com.volmit.adapt.content.adaptation.crafting.CraftingReconstruction;
import com.volmit.adapt.content.adaptation.crafting.CraftingSkulls;
import com.volmit.adapt.content.adaptation.crafting.CraftingStations;
import com.volmit.adapt.content.adaptation.crafting.CraftingXP;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SkillCrafting
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillCrafting() {
        super("crafting", Localizer.dLocalize("skill", "crafting", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "crafting", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "crafting", "name"));
        this.setInterval(3789L);
        this.setIcon(Material.CRAFTING_TABLE);
        this.registerAdaptation(new CraftingDeconstruction());
        this.registerAdaptation(new CraftingXP());
        this.registerAdaptation(new CraftingLeather());
        this.registerAdaptation(new CraftingSkulls());
        this.registerAdaptation(new CraftingBackpacks());
        this.registerAdaptation(new CraftingStations());
        this.registerAdaptation(new CraftingReconstruction());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_1k").title(Localizer.dLocalize("advancement", "challenge_craft_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_5k").title(Localizer.dLocalize("advancement", "challenge_craft_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_50k").title(Localizer.dLocalize("advancement", "challenge_craft_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_500k").title(Localizer.dLocalize("advancement", "challenge_craft_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CRAFTING_TABLE).key("challenge_craft_5m").title(Localizer.dLocalize("advancement", "challenge_craft_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_craft_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_1k").goal(1000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_5k").goal(5000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_50k").goal(50000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_500k").goal(500000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_5m").goal(5000000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeCraft1kReward).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(CraftItemEvent e) {
        Player p = (Player)e.getWhoClicked();
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (!this.isValidCraftEvent(e)) {
                return;
            }
            int recipeAmount = this.calculateRecipeAmount(e);
            if (recipeAmount > 0 && !e.isCancelled()) {
                double v = (double)recipeAmount * this.getValue(e.getRecipe().getResult()) * ((Config)this.getConfig()).craftingValueXPMultiplier;
                this.getPlayer(p).getData().addStat("crafted.items", recipeAmount);
                this.getPlayer(p).getData().addStat("crafted.value", v);
                this.xp(p, v + ((Config)this.getConfig()).baseCraftingXP);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(FurnaceSmeltEvent e) {
        if (this.shouldReturnForWorld(e.getBlock().getWorld(), this)) {
            return;
        }
        this.xp(e.getBlock().getLocation(), ((Config)this.getConfig()).furnaceBaseXP + this.getValue(e.getResult()) * ((Config)this.getConfig()).furnaceValueXPMultiplier, ((Config)this.getConfig()).furnaceXPRadius, ((Config)this.getConfig()).furnaceXPDuration);
    }

    @Override
    public void onTick() {
        for (Player i : Bukkit.getOnlinePlayers()) {
            if (this.shouldReturnForPlayer(i)) continue;
            this.checkStatTrackers(this.getPlayer(i));
        }
    }

    private boolean isValidCraftEvent(CraftItemEvent e) {
        if (this.cooldowns.containsKey(e.getWhoClicked())) {
            if (this.cooldowns.get(e.getWhoClicked()) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return false;
            }
            this.cooldowns.remove(e.getWhoClicked());
        }
        this.cooldowns.put((Player)e.getWhoClicked(), System.currentTimeMillis());
        ItemStack result = e.getInventory().getResult();
        ItemStack cursor = e.getCursor();
        return result != null && result.getAmount() > 0 && (cursor == null || cursor.getAmount() < 64);
    }

    private int calculateRecipeAmount(CraftItemEvent e) {
        ItemStack test = e.getRecipe().getResult().clone();
        int recipeAmount = e.getInventory().getResult().getAmount();
        switch (e.getClick()) {
            case NUMBER_KEY: {
                if (e.getWhoClicked().getInventory().getItem(e.getHotbarButton()) == null) break;
                recipeAmount = 0;
                break;
            }
            case DROP: 
            case CONTROL_DROP: {
                ItemStack cursor = e.getCursor();
                if (cursor == null || cursor.getType().isAir()) break;
                recipeAmount = 0;
                break;
            }
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: {
                if (recipeAmount == 0) break;
                int maxCraftable = this.getMaxCraftAmount(e.getInventory());
                int capacity = this.fits(test, e.getView().getBottomInventory());
                if (capacity < maxCraftable) {
                    maxCraftable = (capacity + recipeAmount - 1) / recipeAmount * recipeAmount;
                }
                recipeAmount = maxCraftable;
                break;
            }
        }
        return recipeAmount;
    }

    private int fits(ItemStack stack, Inventory inv) {
        ItemStack[] contents = inv.getContents();
        int result = 0;
        for (ItemStack is : contents) {
            if (is == null) {
                result += stack.getMaxStackSize();
                continue;
            }
            if (!is.isSimilar(stack)) continue;
            result += Math.max(stack.getMaxStackSize() - is.getAmount(), 0);
        }
        return result;
    }

    private int getMaxCraftAmount(CraftingInventory inv) {
        if (inv.getResult() == null) {
            return 0;
        }
        int resultCount = inv.getResult().getAmount();
        int materialCount = Integer.MAX_VALUE;
        for (ItemStack is : inv.getMatrix()) {
            if (is == null || is.getAmount() >= materialCount) continue;
            materialCount = is.getAmount();
        }
        return resultCount * materialCount;
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double furnaceBaseXP = 24.0;
        double furnaceValueXPMultiplier = 4.0;
        int furnaceXPRadius = 32;
        long cooldownDelay = 10000L;
        long furnaceXPDuration = 10000L;
        double craftingValueXPMultiplier = 1.0;
        double baseCraftingXP = 0.25;
        double challengeCraft1kReward = 1200.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

