/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.hunter.HunterAdrenaline;
import com.volmit.adapt.content.adaptation.hunter.HunterDropToInventory;
import com.volmit.adapt.content.adaptation.hunter.HunterInvis;
import com.volmit.adapt.content.adaptation.hunter.HunterJumpBoost;
import com.volmit.adapt.content.adaptation.hunter.HunterLuck;
import com.volmit.adapt.content.adaptation.hunter.HunterRegen;
import com.volmit.adapt.content.adaptation.hunter.HunterResistance;
import com.volmit.adapt.content.adaptation.hunter.HunterSpeed;
import com.volmit.adapt.content.adaptation.hunter.HunterStrength;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SkillHunter
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillHunter() {
        super("hunter", Localizer.dLocalize("skill", "hunter", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.RED);
        this.setDescription(Localizer.dLocalize("skill", "hunter", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "hunter", "name"));
        this.setInterval(4150L);
        this.setIcon(Material.BONE);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new HunterAdrenaline());
        this.registerAdaptation(new HunterRegen());
        this.registerAdaptation(new HunterInvis());
        this.registerAdaptation(new HunterJumpBoost());
        this.registerAdaptation(new HunterLuck());
        this.registerAdaptation(new HunterSpeed());
        this.registerAdaptation(new HunterStrength());
        this.registerAdaptation(new HunterResistance());
        this.registerAdaptation(new HunterDropToInventory());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.TURTLE_EGG).key("horrible_person").title(Localizer.dLocalize("advancement", "horrible_person", "title")).description(Localizer.dLocalize("advancement", "horrible_person", "description")).frame(AdvancementDisplay.AdvancementFrame.GOAL).visibility(AdvancementVisibility.HIDDEN).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.TURTLE_EGG).key("challenge_turtle_egg_smasher").title(Localizer.dLocalize("advancement", "challenge_turtle_egg_smasher", "title")).description(Localizer.dLocalize("advancement", "challenge_turtle_egg_smasher", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.TURTLE_EGG).key("challenge_turtle_egg_annihilator").title(Localizer.dLocalize("advancement", "challenge_turtle_egg_annihilator", "title")).description(Localizer.dLocalize("advancement", "challenge_turtle_egg_annihilator", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.BONE).key("challenge_novice_hunter").title(Localizer.dLocalize("advancement", "challenge_novice_hunter", "title")).description(Localizer.dLocalize("advancement", "challenge_novice_hunter", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_SWORD).key("challenge_intermediate_hunter").title(Localizer.dLocalize("advancement", "challenge_intermediate_hunter", "title")).description(Localizer.dLocalize("advancement", "challenge_intermediate_hunter", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_SWORD).key("challenge_advanced_hunter").title(Localizer.dLocalize("advancement", "challenge_advanced_hunter", "title")).description(Localizer.dLocalize("advancement", "challenge_advanced_hunter", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.CREEPER_HEAD).key("challenge_creeper_conqueror").title(Localizer.dLocalize("advancement", "challenge_creeper_conqueror", "title")).description(Localizer.dLocalize("advancement", "challenge_creeper_conqueror", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.TNT).key("challenge_creeper_annihilator").title(Localizer.dLocalize("advancement", "challenge_creeper_annihilator", "title")).description(Localizer.dLocalize("advancement", "challenge_creeper_annihilator", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("horrible_person").goal(1.0).stat("killed.turtleeggs").reward(((Config)this.getConfig()).turtleEggKillXP).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_turtle_egg_smasher").goal(100.0).stat("killed.turtleeggs").reward(((Config)this.getConfig()).turtleEggKillXP * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_turtle_egg_annihilator").goal(1000.0).stat("killed.turtleeggs").reward(((Config)this.getConfig()).turtleEggKillXP * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_novice_hunter").goal(100.0).stat("killed.monsters").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_intermediate_hunter").goal(1000.0).stat("killed.monsters").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_advanced_hunter").goal(10000.0).stat("killed.monsters").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_creeper_conqueror").goal(100.0).stat("killed.creepers").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_creeper_annihilator").goal(1000.0).stat("killed.creepers").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
    }

    private void handleCooldownAndXp(Player p, double xpAmount) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(p);
        }
        this.cooldowns.put(p, System.currentTimeMillis());
        this.xp(p, xpAmount);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getBlock().getType().equals((Object)Material.TURTLE_EGG)) {
                this.handleCooldownAndXp(p, ((Config)this.getConfig()).turtleEggKillXP);
                this.getPlayer(p).getData().addStat("killed.tutleeggs", 1.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getAction().equals((Object)Action.PHYSICAL) && e.getClickedBlock() != null && e.getClickedBlock().getType().equals((Object)Material.TURTLE_EGG)) {
                this.handleCooldownAndXp(p, ((Config)this.getConfig()).turtleEggKillXP);
                this.getPlayer(p).getData().addStat("killed.tutleeggs", 1.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDeathEvent e) {
        if (e.getEntity().getKiller() == null) {
            return;
        }
        Player p = e.getEntity().getKiller();
        if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
            return;
        }
        this.shouldReturnForPlayer(p, () -> {
            if (e.getEntity().getType().equals((Object)EntityType.CREEPER)) {
                double cmult = ((Config)this.getConfig()).creeperKillMultiplier;
                double xpAmount = e.getEntity().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * ((Config)this.getConfig()).killMaxHealthXPMultiplier * cmult;
                if (e.getEntity().getPortalCooldown() > 0) {
                    xpAmount *= ((Config)this.getConfig()).spawnerMobReductionXpMultiplier;
                }
                this.getPlayer(p).getData().addStat("killed.kills", 1.0);
                this.handleCooldownAndXp(p, xpAmount);
            } else {
                this.handleEntityKill(p, (Entity)e.getEntity());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(CreatureSpawnEvent e) {
        if (!this.isEnabled() || e.isCancelled()) {
            return;
        }
        if (e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            LivingEntity ent = e.getEntity();
            ent.setPortalCooldown(630726000);
        }
    }

    private void handleEntityKill(Player p, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double xpAmount = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * ((Config)this.getConfig()).killMaxHealthXPMultiplier;
            if (entity.getPortalCooldown() > 0) {
                xpAmount *= ((Config)this.getConfig()).spawnerMobReductionXpMultiplier;
            }
            this.getPlayer(p).getData().addStat("killed.kills", 1.0);
            this.handleCooldownAndXp(p, xpAmount);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double turtleEggKillXP = 100.0;
        double creeperKillMultiplier = 2.0;
        double killMaxHealthXPMultiplier = 4.0;
        long cooldownDelay = 1000L;
        double spawnerMobReductionXpMultiplier = 0.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

