/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneFishersFantasy;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneOxygen;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneSpeed;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneTurtlesMiningSpeed;
import com.volmit.adapt.content.adaptation.seaborrne.SeaborneTurtlesVision;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerFishEvent;

public class SkillSeaborne
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillSeaborne() {
        super("seaborne", Localizer.dLocalize("skill", "seaborne", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.BLUE);
        this.setDescription(Localizer.dLocalize("skill", "seaborne", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "seaborne", "name"));
        this.setInterval(2120L);
        this.setIcon(Material.TRIDENT);
        this.registerAdaptation(new SeaborneOxygen());
        this.registerAdaptation(new SeaborneSpeed());
        this.registerAdaptation(new SeaborneFishersFantasy());
        this.registerAdaptation(new SeaborneTurtlesVision());
        this.registerAdaptation(new SeaborneTurtlesMiningSpeed());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.TURTLE_HELMET).key("challenge_swim_1nm").title("Human Submarine!").description("Swim 1 Nautical Mile (1,852 blocks)").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_swim_1nm").goal(1852.0).stat("move.swim").reward(((Config)this.getConfig()).challengeSwim1nmReward).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    private boolean isOnCooldown(Player p, long cooldown) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + cooldown > System.currentTimeMillis()) {
                return true;
            }
            this.cooldowns.remove(p);
        }
        return false;
    }

    private void setCooldown(Player p) {
        this.cooldowns.put(p, System.currentTimeMillis());
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player i : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(i, () -> {
                if (i.getWorld().getBlockAt(i.getLocation()).isLiquid() && i.isSwimming() && i.getPlayer() != null && i.getPlayer().getRemainingAir() < i.getMaximumAir()) {
                    Adapt.verbose("seaborne Tick");
                    this.checkStatTrackers(this.getPlayer(i));
                    this.xpSilent(i, ((Config)this.getConfig()).swimXP);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerFishEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH)) {
                this.xp(p, 300.0);
            } else if (e.getState().equals((Object)PlayerFishEvent.State.CAUGHT_ENTITY)) {
                this.xp(p, 10.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (this.isOnCooldown(p, ((Config)this.getConfig()).seaPickleCooldown)) {
                return;
            }
            this.setCooldown(p);
            if (e.getBlock().getType().equals((Object)Material.SEA_PICKLE) && p.isSwimming() && p.getRemainingAir() < p.getMaximumAir()) {
                this.xpSilent(p, 10.0);
            } else {
                this.xpSilent(p, 3.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Projectile projectile;
        Entity entity;
        Player p;
        Entity entity2;
        if (e.getEntity() instanceof Drowned && (entity2 = e.getDamager()) instanceof Player) {
            p = (Player)entity2;
            this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
                if (this.isOnCooldown(p, ((Config)this.getConfig()).seaPickleCooldown)) {
                    return;
                }
                this.setCooldown(p);
                this.xp(p, ((Config)this.getConfig()).damagedrownxpmultiplier * Math.min(e.getDamage(), ((LivingEntity)e.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
            });
        }
        if ((entity = e.getDamager()) instanceof Projectile && (projectile = (Projectile)entity) instanceof Trident && (entity = ((Projectile)e.getDamager()).getShooter()) instanceof Player) {
            Player p2 = (Player)entity;
            this.shouldReturnForPlayer(p2, (Cancellable)e, () -> this.xp(p2, ((Config)this.getConfig()).tridentxpmultiplier * Math.min(e.getDamage(), ((LivingEntity)e.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue())));
        }
        if ((entity2 = e.getDamager()) instanceof Player && (p = (Player)entity2).getInventory().getItemInMainHand().getType().equals((Object)Material.TRIDENT)) {
            this.shouldReturnForPlayer(p, (Cancellable)e, () -> this.xp(p, ((Config)this.getConfig()).tridentxpmultiplier * Math.min(e.getDamage(), ((LivingEntity)e.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue())));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public long seaPickleCooldown = 60000L;
        public double tridentxpmultiplier = 2.5;
        double damagedrownxpmultiplier = 3.0;
        boolean enabled = true;
        double challengeSwim1nmReward = 750.0;
        double swimXP = 28.7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

