/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.content.adaptation.sword.SwordsBloodyBlade;
import com.volmit.adapt.content.adaptation.sword.SwordsMachete;
import com.volmit.adapt.content.adaptation.sword.SwordsPoisonedBlade;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillSwords
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillSwords() {
        super("swords", Localizer.dLocalize("skill", "swords", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "swords", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "swords", "name"));
        this.setInterval(2150L);
        this.setIcon(Material.DIAMOND_SWORD);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new SwordsMachete());
        this.registerAdaptation(new SwordsPoisonedBlade());
        this.registerAdaptation(new SwordsBloodyBlade());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (this.checkValidEntity(e.getEntity().getType())) {
                this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
                    AdaptPlayer a = this.getPlayer(p);
                    ItemStack hand = a.getPlayer().getInventory().getItemInMainHand();
                    if (this.isSword(hand)) {
                        this.getPlayer(p).getData().addStat("sword.hits", 1.0);
                        this.getPlayer(p).getData().addStat("sword.damage", e.getDamage());
                        if (!this.isOnCooldown(p)) {
                            this.setCooldown(p);
                            this.xp(a.getPlayer(), e.getEntity().getLocation(), ((Config)this.getConfig()).damageXPMultiplier * e.getDamage());
                        }
                    }
                });
            }
        }
    }

    private boolean isOnCooldown(Player p) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return true;
            }
            this.cooldowns.remove(p);
        }
        return false;
    }

    private void setCooldown(Player p) {
        this.cooldowns.put(p, System.currentTimeMillis());
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        long cooldownDelay = 1250L;
        double damageXPMultiplier = 7.26;

        static {
            IBootstrap.dasBoot();
        }
    }
}

