/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class Area {
    private Location location;
    private Double radius;

    public Area(Location location, Double radius) {
        this.location = location;
        this.radius = radius;
    }

    public Area(Location location, Integer radius) {
        this.location = location;
        this.radius = (double)radius;
    }

    public static boolean within(Location center, Location target, double rad) {
        return new Area(center, rad).isWithin(target);
    }

    public Cuboid toCuboid() {
        return new Cuboid(this.location.clone().add(this.radius.doubleValue(), this.radius.doubleValue(), this.radius.doubleValue()), this.location.clone().subtract(this.radius.doubleValue(), this.radius.doubleValue(), this.radius.doubleValue()));
    }

    public Double distance(Location location) {
        double c;
        double t = c = this.location.distanceSquared(location);
        for (int i = 0; i < 3; ++i) {
            t = (c / t + t) / 2.0;
        }
        return t;
    }

    public Double slowDistance(Location location) {
        return this.location.distance(location);
    }

    public boolean isWithin(Location location) {
        return this.location.distance(location) <= this.radius * this.radius;
    }

    public boolean hasEntities() {
        return this.getNearbyEntities().length > 0;
    }

    public Entity[] getNearbyEntities(EntityType type) {
        ArrayList e = new ArrayList();
        XList.add(e, this.getNearbyEntities());
        for (Entity i : XList.copy(e)) {
            if (i.getType().equals((Object)type)) continue;
            e.remove(i);
        }
        return e.toArray(new Entity[e.size()]);
    }

    public Entity[] getNearbyEntities(Class<? extends Entity> entityClass) {
        ArrayList e = new ArrayList();
        XList.add(e, this.getNearbyEntities());
        for (Entity i : XList.copy(e)) {
            if (i.getClass().isAssignableFrom(entityClass)) continue;
            e.remove(i);
        }
        return e.toArray(new Entity[0]);
    }

    public Entity[] getNearbyEntities() {
        try {
            int chunkRadius = (int)(this.radius < 16.0 ? 1.0 : (this.radius - this.radius % 16.0) / 16.0);
            HashSet<Entity> radiusEntities = new HashSet<Entity>();
            for (int chX = 0 - chunkRadius; chX <= chunkRadius; ++chX) {
                for (int chZ = 0 - chunkRadius; chZ <= chunkRadius; ++chZ) {
                    int x = (int)this.location.getX();
                    int y = (int)this.location.getY();
                    int z = (int)this.location.getZ();
                    for (Entity e : new Location(this.location.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                        if (!(e.getLocation().distanceSquared(this.location) <= this.radius * this.radius) || e.getLocation().getBlock() == this.location.getBlock()) continue;
                        radiusEntities.add(e);
                    }
                }
            }
            return radiusEntities.toArray(new Entity[radiusEntities.size()]);
        }
        catch (Exception e) {
            return new ArrayList().toArray(new Entity[0]);
        }
    }

    public Player[] getNearbyPlayers() {
        ArrayList<Player> px = new ArrayList<Player>();
        for (Entity i : this.getNearbyEntities()) {
            if (!i.getType().equals((Object)EntityType.PLAYER)) continue;
            px.add((Player)i);
        }
        return px.toArray(new Player[0]);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public Location random() {
        Random r = new Random();
        double x = this.radius * ((r.nextDouble() - 0.5) * 2.0);
        double y = this.radius * ((r.nextDouble() - 0.5) * 2.0);
        double z = this.radius * ((r.nextDouble() - 0.5) * 2.0);
        return this.location.clone().add(x, y, z);
    }

    static {
        IBootstrap.dasBoot();
    }
}

