/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.C;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.apache.commons.lang.StringUtils;

public class BoardEntry {
    private final String prefix;
    private final String suffix;

    private BoardEntry(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static BoardEntry translateToEntry(String input) {
        if (input.isEmpty()) {
            return new BoardEntry("", "");
        }
        if (input.length() <= 16) {
            return new BoardEntry(input, "");
        }
        String prefix = input.substring(0, 16);
        Object suffix = "";
        if (prefix.endsWith("\u00a7")) {
            prefix = prefix.substring(0, prefix.length() - 1);
            suffix = "\u00a7" + (String)suffix;
        }
        suffix = StringUtils.left((String)(C.getLastColors(prefix) + (String)suffix + input.substring(16)), (int)16);
        return new BoardEntry(prefix, (String)suffix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    static {
        IBootstrap.dasBoot();
    }
}

