/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public class ChronoLatch {
    private final long interval;
    private long since;

    public ChronoLatch(long interval, boolean openedAtStart) {
        this.interval = interval;
        this.since = System.currentTimeMillis() - (openedAtStart ? interval * 2L : 0L);
    }

    public ChronoLatch(long interval) {
        this(interval, true);
    }

    public void flipDown() {
        this.since = System.currentTimeMillis();
    }

    public boolean couldFlip() {
        return System.currentTimeMillis() - this.since > this.interval;
    }

    public boolean flip() {
        if (System.currentTimeMillis() - this.since > this.interval) {
            this.since = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    static {
        IBootstrap.dasBoot();
    }
}

