/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.NibbleArray;
import com.volmit.adapt.util.Writable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DataPalette<T>
implements Writable {
    private static final int DEFAULT_BITS_PER_BLOCK = 4;
    private static final int CAPACITY = 4096;
    private int bpb = 4;
    private NibbleArray data;
    private List<T> palette = new ArrayList<T>();

    public DataPalette(T defaultValue) {
        this.data = new NibbleArray(this.bpb, 4096);
        this.data.setAll((byte)-128);
        this.getPaletteId(defaultValue);
    }

    public abstract T readType(DataInputStream var1) throws IOException;

    public abstract void writeType(T var1, DataOutputStream var2) throws IOException;

    @Override
    public void write(DataOutputStream o) throws IOException {
        o.writeByte(this.bpb + -128);
        o.writeByte(this.palette.size() + -128);
        for (T i : this.palette) {
            this.writeType(i, o);
        }
        this.data.write(o);
    }

    @Override
    public void read(DataInputStream i) throws IOException {
        this.bpb = i.readByte() - -128;
        this.palette = new ArrayList<T>();
        int v = i.readByte() - -128;
        for (int j = 0; j < v; ++j) {
            this.palette.add(this.readType(i));
        }
        this.data = new NibbleArray(4096, i);
    }

    private final void expand() {
        if (this.bpb >= 8) {
            throw new IndexOutOfBoundsException("The Data Palette can only handle at most 256 block types per 16x16x16 region. We cannot use more than 8 bits per block!");
        }
        this.changeBitsPerBlock(this.bpb + 1);
    }

    public final void optimize() {
        int targetBits = this.bpb;
        int needed = this.palette.size();
        for (int i = 1; i < this.bpb; ++i) {
            if (!(Math.pow(2.0, i) > (double)needed)) continue;
            targetBits = i;
            break;
        }
        this.changeBitsPerBlock(targetBits);
    }

    private final void changeBitsPerBlock(int bits) {
        this.bpb = bits;
        this.data = new NibbleArray(this.bpb, 4096, this.data);
    }

    public final void set(int x, int y, int z, T d) {
        this.data.set(this.getCoordinateIndex(x, y, z), this.getPaletteId(d));
    }

    public final T get(int x, int y, int z) {
        return this.palette.get(this.data.get(this.getCoordinateIndex(x, y, z)));
    }

    private final int getPaletteId(T d) {
        int index = this.palette.indexOf(d);
        if (index == -1) {
            index = this.palette.size();
            this.palette.add(d);
            if ((double)this.palette.size() > Math.pow(2.0, this.bpb)) {
                this.expand();
            }
        }
        return index + -128;
    }

    private final int getCoordinateIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    static {
        IBootstrap.dasBoot();
    }
}

