/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RollingSequence;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Form {
    private static final String[] NAMES;
    private static final BigInteger THOUSAND;
    private static final NavigableMap<BigInteger, String> MAP;
    private static final LinkedHashMap<String, Integer> roman_numerals;
    private static NumberFormat NF;
    private static DecimalFormat DF;

    private static void instantiate() {
        if (NF == null) {
            NF = NumberFormat.getInstance(Locale.US);
        }
    }

    public static String scroll(String smx, int viewport, long time) {
        String src = Form.repeat(" ", viewport) + smx + Form.repeat(" ", viewport);
        int len = src.length();
        int walk = (int)(time % (long)(len - viewport));
        String base = src.substring(walk, (Integer)M.min((Number[])new Integer[]{walk + viewport, len - 1}));
        base = base.length() < viewport ? base + Form.repeat(" ", viewport - base.length() - 3) : base;
        return base;
    }

    public static String capitalize(String s) {
        Object roll = "";
        boolean f = true;
        char[] cArray = s.trim().toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character i2 = Character.valueOf(cArray[i]);
            if (f) {
                roll = (String)roll + Character.toUpperCase(i2.charValue());
                f = false;
                continue;
            }
            roll = (String)roll + i2;
        }
        return roll;
    }

    public static String capitalizeWords(String s) {
        Object rollx = "";
        for (String i : s.trim().split(" ")) {
            rollx = (String)rollx + " " + Form.capitalize(i.trim());
        }
        return ((String)rollx).substring(1);
    }

    public static String wrap(String s, int len) {
        return Form.wrap(s, len, null, false);
    }

    public static String wrapWords(String s, int len) {
        return Form.wrap(s, len, null, true);
    }

    public static String wrapWordsPrefixed(String s, String prefix, int len) {
        return Form.wrapPrefixed(s, prefix, len, null, true);
    }

    public static String wrap(String s, int len, String newLineSep, boolean soft) {
        return Form.wrap(s, len, newLineSep, soft, " ");
    }

    public static String wrapPrefixed(String s, String pref, int len, String newLineSep, boolean soft) {
        return pref + Form.wrapPrefixed(s, pref, len, newLineSep, soft, " ").replaceAll("\\Q\n\\E", "\n" + pref);
    }

    public static String wrap(String s, int len, String newLineSep, boolean soft, String regex) {
        if (s == null) {
            return null;
        }
        if (newLineSep == null) {
            newLineSep = "\n";
        }
        if (len < 1) {
            len = 1;
        }
        if (regex.trim().equals("")) {
            regex = " ";
        }
        Pattern arg4 = Pattern.compile(regex);
        int arg5 = s.length();
        int arg6 = 0;
        StringBuilder arg7 = new StringBuilder(arg5 + 32);
        while (arg6 < arg5) {
            int arg8 = -1;
            Matcher arg9 = arg4.matcher(s.substring(arg6, Math.min(arg6 + len + 1, arg5)));
            if (arg9.find()) {
                if (arg9.start() == 0) {
                    arg6 += arg9.end();
                    continue;
                }
                arg8 = arg9.start();
            }
            if (arg5 - arg6 <= len) break;
            while (arg9.find()) {
                arg8 = arg9.start() + arg6;
            }
            if (arg8 >= arg6) {
                arg7.append(s, arg6, arg8);
                arg7.append(newLineSep);
                arg6 = arg8 + 1;
                continue;
            }
            if (soft) {
                arg7.append(s, arg6, len + arg6);
                arg7.append(newLineSep);
                arg6 += len;
                continue;
            }
            arg9 = arg4.matcher(s.substring(arg6 + len));
            if (arg9.find()) {
                arg8 = arg9.start() + arg6 + len;
            }
            if (arg8 >= 0) {
                arg7.append(s, arg6, arg8);
                arg7.append(newLineSep);
                arg6 = arg8 + 1;
                continue;
            }
            arg7.append(s.substring(arg6));
            arg6 = arg5;
        }
        arg7.append(s.substring(arg6));
        return arg7.toString();
    }

    public static String wrapPrefixed(String s, String pref, int len, String newLineSep, boolean soft, String regex) {
        if (s == null) {
            return null;
        }
        if (newLineSep == null) {
            newLineSep = "\n";
        }
        if (len < 1) {
            len = 1;
        }
        if (regex.trim().equals("")) {
            regex = " ";
        }
        Pattern arg4 = Pattern.compile(regex);
        int arg5 = s.length();
        int arg6 = 0;
        StringBuilder arg7 = new StringBuilder(arg5 + 32);
        while (arg6 < arg5) {
            int arg8 = -1;
            Matcher arg9 = arg4.matcher(s.substring(arg6, Math.min(arg6 + len + 1, arg5)));
            if (arg9.find()) {
                if (arg9.start() == 0) {
                    arg6 += arg9.end();
                    continue;
                }
                arg8 = arg9.start();
            }
            if (arg5 - arg6 <= len) break;
            while (arg9.find()) {
                arg8 = arg9.start() + arg6;
            }
            if (arg8 >= arg6) {
                arg7.append(s, arg6, arg8);
                arg7.append(newLineSep);
                arg6 = arg8 + 1;
                continue;
            }
            if (soft) {
                arg7.append(s, arg6, len + arg6);
                arg7.append(newLineSep);
                arg6 += len;
                continue;
            }
            arg9 = arg4.matcher(s.substring(arg6 + len));
            if (arg9.find()) {
                arg8 = arg9.start() + arg6 + len;
            }
            if (arg8 >= 0) {
                arg7.append(s, arg6, arg8);
                arg7.append(newLineSep);
                arg6 = arg8 + 1;
                continue;
            }
            arg7.append(s.substring(arg6));
            arg6 = arg5;
        }
        arg7.append(s.substring(arg6));
        return arg7.toString();
    }

    public static String duration(RollingSequence rollingSequence, long duration) {
        String suffix = "Millisecond";
        double phantom = duration;
        int div = 1000;
        if (phantom > (double)div) {
            phantom /= (double)div;
            suffix = "Second";
            div = 60;
            if (phantom > (double)div) {
                phantom /= (double)div;
                suffix = "Minute";
                if (phantom > (double)div) {
                    phantom /= (double)div;
                    suffix = "Hour";
                    div = 24;
                    if (phantom > 24.0) {
                        phantom /= (double)div;
                        suffix = "Day";
                        div = 7;
                        if (phantom > (double)div) {
                            phantom /= (double)div;
                            suffix = "Week";
                            div = 4;
                            if (phantom > (double)div) {
                                phantom /= (double)div;
                                suffix = "Month";
                                div = 12;
                                if (phantom > (double)div) {
                                    suffix = "Year";
                                    return Form.fd(phantom /= (double)div, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
                                }
                                return Form.fd(phantom, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
                            }
                            return Form.fd(phantom, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
                        }
                        return Form.fd(phantom, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
                    }
                    return Form.fd(phantom, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
                }
                return Form.fd(phantom, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
            }
            return Form.fd(phantom, 0) + " " + suffix + ((int)phantom == 1 ? "" : "s");
        }
        return "Under a Second";
    }

    public static String fmin(Calendar c) {
        String s = "" + c.get(12);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String ago(long time) {
        boolean sameDay;
        long current = M.ms();
        if (time > current - TimeUnit.SECONDS.toMillis(30L) && time < current) {
            return "Just Now";
        }
        if (time > current - TimeUnit.SECONDS.toMillis(60L) && time < current) {
            return "Seconds Ago";
        }
        if (time > current - TimeUnit.MINUTES.toMillis(10L) && time < current) {
            return "Minutes Ago";
        }
        Calendar now = Calendar.getInstance();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        boolean sameYear = now.get(1) == c.get(1);
        boolean bl = sameDay = now.get(6) == c.get(6);
        if (sameDay) {
            int h = c.get(10);
            h = h == 0 ? 12 : h;
            return "Today at " + h + ":" + Form.fmin(c) + " " + (c.get(9) == 1 ? "PM" : "AM");
        }
        if (sameYear) {
            boolean yesterday;
            boolean bl2 = yesterday = now.get(6) - 1 == c.get(6);
            if (yesterday) {
                int h = c.get(10);
                h = h == 0 ? 12 : h;
                return "Yesterday at " + h + ":" + Form.fmin(c) + " " + (c.get(9) == 1 ? "PM" : "AM");
            }
            int h = c.get(10);
            h = h == 0 ? 12 : h;
            String dow = "Error Day";
            switch (c.get(7)) {
                case 1: {
                    dow = "Sunday";
                    break;
                }
                case 2: {
                    dow = "Monday";
                    break;
                }
                case 3: {
                    dow = "Tuesday";
                    break;
                }
                case 4: {
                    dow = "Wednesday";
                    break;
                }
                case 5: {
                    dow = "Thursday";
                    break;
                }
                case 6: {
                    dow = "Friday";
                    break;
                }
                case 7: {
                    dow = "Saturday";
                }
            }
            String monthName = "Error Month";
            int month = c.get(2);
            switch (month) {
                case 0: {
                    monthName = "Jan";
                    break;
                }
                case 1: {
                    monthName = "Feb";
                    break;
                }
                case 2: {
                    monthName = "Mar";
                    break;
                }
                case 3: {
                    monthName = "Apr";
                    break;
                }
                case 4: {
                    monthName = "May";
                    break;
                }
                case 5: {
                    monthName = "Jun";
                    break;
                }
                case 6: {
                    monthName = "Jul";
                    break;
                }
                case 7: {
                    monthName = "Aug";
                    break;
                }
                case 8: {
                    monthName = "Sep";
                    break;
                }
                case 9: {
                    monthName = "Oct";
                    break;
                }
                case 10: {
                    monthName = "Nov";
                    break;
                }
                case 11: {
                    monthName = "Dec";
                }
            }
            int dayOfMonth = c.get(5);
            String suffix = Form.numberSuffix(dayOfMonth);
            return dow + ", " + monthName + " " + suffix + " at " + h + ":" + Form.fmin(c) + " " + (c.get(9) == 1 ? "PM" : "AM");
        }
        int h = c.get(10);
        h = h == 0 ? 12 : h;
        String dow = "Error Day";
        switch (c.get(7)) {
            case 1: {
                dow = "Sunday";
                break;
            }
            case 2: {
                dow = "Monday";
                break;
            }
            case 3: {
                dow = "Tuesday";
                break;
            }
            case 4: {
                dow = "Wednesday";
                break;
            }
            case 5: {
                dow = "Thursday";
                break;
            }
            case 6: {
                dow = "Friday";
                break;
            }
            case 7: {
                dow = "Saturday";
            }
        }
        String monthName = "Error Month";
        int month = c.get(2);
        switch (month) {
            case 0: {
                monthName = "Jan";
                break;
            }
            case 1: {
                monthName = "Feb";
                break;
            }
            case 2: {
                monthName = "Mar";
                break;
            }
            case 3: {
                monthName = "Apr";
                break;
            }
            case 4: {
                monthName = "May";
                break;
            }
            case 5: {
                monthName = "Jun";
                break;
            }
            case 6: {
                monthName = "Jul";
                break;
            }
            case 7: {
                monthName = "Aug";
                break;
            }
            case 8: {
                monthName = "Sep";
                break;
            }
            case 9: {
                monthName = "Oct";
                break;
            }
            case 10: {
                monthName = "Nov";
                break;
            }
            case 11: {
                monthName = "Dec";
            }
        }
        int dayOfMonth = c.get(5);
        String suffix = Form.numberSuffix(dayOfMonth);
        int year = c.get(1);
        return year + ", " + dow + ", " + monthName + " " + suffix + " at " + h + ":" + Form.fmin(c) + " " + (c.get(9) == 1 ? "PM" : "AM");
    }

    public static String numberSuffix(int i) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + sufixes[i % 10];
    }

    public static String duration(double ms, int prec) {
        if (ms < 1000.0) {
            return Form.f(ms, prec) + "ms";
        }
        if (ms / 1000.0 < 60.0) {
            return Form.f(ms / 1000.0, prec) + "s";
        }
        if (ms / 1000.0 / 60.0 < 60.0) {
            return Form.f(ms / 1000.0 / 60.0, prec) + "m";
        }
        if (ms / 1000.0 / 60.0 / 60.0 < 24.0) {
            return Form.f(ms / 1000.0 / 60.0 / 60.0, prec) + " hours";
        }
        if (ms / 1000.0 / 60.0 / 60.0 / 24.0 < 7.0) {
            return Form.f(ms / 1000.0 / 60.0 / 24.0, prec) + " days";
        }
        return Form.f(ms, prec) + "ms";
    }

    public static String duration(long ms) {
        return Form.duration(ms, 0);
    }

    public static String duration(long ms, int prec) {
        if ((double)ms < 1000.0) {
            return Form.f(ms, prec) + "ms";
        }
        if ((double)ms / 1000.0 < 60.0) {
            return Form.f((double)ms / 1000.0, prec) + " seconds";
        }
        if ((double)ms / 1000.0 / 60.0 < 60.0) {
            return Form.f((double)ms / 1000.0 / 60.0, prec) + " minutes";
        }
        if ((double)ms / 1000.0 / 60.0 / 60.0 < 24.0) {
            return Form.f((double)ms / 1000.0 / 60.0 / 60.0, prec) + " hours";
        }
        if ((double)ms / 1000.0 / 60.0 / 60.0 / 24.0 < 7.0) {
            return Form.f((double)ms / 1000.0 / 60.0 / 24.0, prec) + " days";
        }
        return Form.f(ms, prec) + "ms";
    }

    public static String b(int i) {
        return Form.b(new BigInteger(String.valueOf(i)));
    }

    public static String b(long i) {
        return Form.b(new BigInteger(String.valueOf(i)));
    }

    public static String b(double i) {
        return Form.b(new BigInteger(String.valueOf((long)i)));
    }

    public static String b(BigInteger number) {
        Map.Entry<BigInteger, String> entry = MAP.floorEntry(number);
        if (entry == null) {
            return "Nearly nothing";
        }
        BigInteger key = entry.getKey();
        BigInteger d = key.divide(THOUSAND);
        BigInteger m = number.divide(d);
        float f = m.floatValue() / 1000.0f;
        float rounded = (float)((int)((double)f * 100.0)) / 100.0f;
        if (rounded % 1.0f == 0.0f) {
            return (int)rounded + " " + entry.getValue();
        }
        return rounded + " " + entry.getValue();
    }

    public static String fileSize(long s) {
        return Form.ofSize(s, 1000);
    }

    public static String split(String splitter, String ... strings) {
        StringBuilder b = new StringBuilder();
        for (String i : strings) {
            b.append(splitter);
            b.append(i);
        }
        return b.substring(splitter.length());
    }

    public static String memSize(long s) {
        return Form.ofSize(s, 1024);
    }

    public static String memSize(long s, int dec) {
        return Form.ofSize(s, 1024, dec);
    }

    public static String stamp(long t) {
        Date d = new Date(t);
        return d.getMonth() + "-" + d.getDate() + "-" + (d.getYear() + 1900) + " " + d.getHours() + "h " + d.getMinutes() + "m " + d.getSeconds() + "s ";
    }

    public static String stampTime(long t) {
        Date d = new Date(t);
        return Calendar.getInstance().get(11) + ":" + Form.forceDoubleDigit(d.getMinutes()) + ":" + Form.forceDoubleDigit(d.getSeconds());
    }

    public static String forceDoubleDigit(int dig) {
        if (dig < 10) {
            return "0" + dig;
        }
        return "" + dig;
    }

    public static String stampDay(long t) {
        Date d = new Date(t);
        return d.getMonth() + "-" + d.getDate() + "-" + (d.getYear() + 1900);
    }

    public static String ofSize(long s, int div) {
        Double d = s;
        String sub = "Bytes";
        if (d > (double)(div - 1)) {
            d = d / (double)div;
            sub = "KB";
            if (d > (double)(div - 1)) {
                d = d / (double)div;
                sub = "MB";
                if (d > (double)(div - 1)) {
                    d = d / (double)div;
                    sub = "GB";
                    if (d > (double)(div - 1)) {
                        d = d / (double)div;
                        sub = "TB";
                    }
                }
            }
        }
        if (sub.equals("GB") || sub.equals("TB")) {
            return Form.f(d, 1) + sub;
        }
        return Form.f(d, 0) + sub;
    }

    public static String ofSize(long s, int div, int dec) {
        Double d = s;
        String sub = "Bytes";
        if (d > (double)(div - 1)) {
            d = d / (double)div;
            sub = "KB";
            if (d > (double)(div - 1)) {
                d = d / (double)div;
                sub = "MB";
                if (d > (double)(div - 1)) {
                    d = d / (double)div;
                    sub = "GB";
                    if (d > (double)(div - 1)) {
                        d = d / (double)div;
                        sub = "TB";
                    }
                }
            }
        }
        return Form.f(d, dec) + " " + sub;
    }

    public static String ofSizeMetricWeight(long s, int div, int dec) {
        boolean neg;
        boolean bl = neg = s < 0L;
        if (neg) {
            s = -s;
        }
        Double d = s;
        String sub = "Grams";
        if (d > (double)(div - 1)) {
            d = d / (double)div;
            sub = "KG";
            if (d > (double)(div - 1)) {
                d = d / (double)div;
                sub = "MG";
                if (d > (double)(div - 1)) {
                    d = d / (double)div;
                    sub = "GG";
                    if (d > (double)(div - 1)) {
                        d = d / (double)div;
                        sub = "TG";
                    }
                }
            }
        }
        return (neg ? "-" : "") + Form.f(d, dec) + " " + sub;
    }

    public static String trim(String s, int l) {
        if (s.length() <= l) {
            return s;
        }
        return s.substring(0, l) + "...";
    }

    public static String cname(String clazz) {
        Object codeName = "";
        char[] cArray = clazz.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character i2 = Character.valueOf(cArray[i]);
            codeName = Character.isUpperCase(i2.charValue()) ? (String)codeName + "-" + Character.toLowerCase(i2.charValue()) : (String)codeName + i2;
        }
        if (((String)codeName).startsWith("-")) {
            codeName = ((String)codeName).substring(1);
        }
        return codeName;
    }

    public static String mem(long mb) {
        if (mb < 1024L) {
            return Form.f(mb) + " MB";
        }
        return Form.f((double)mb / 1024.0, 1) + " GB";
    }

    public static String memx(long kb) {
        if (kb < 1024L) {
            return Form.fd(kb, 2) + " KB";
        }
        double mb = (double)kb / 1024.0;
        if (mb < 1024.0) {
            return Form.fd(mb, 2) + " MB";
        }
        double gb = mb / 1024.0;
        return Form.fd(gb, 2) + " GB";
    }

    public static String f(long i) {
        Form.instantiate();
        return NF.format(i);
    }

    public static String f(int i) {
        Form.instantiate();
        return NF.format(i);
    }

    public static String f(double i, int p) {
        Object form = "#";
        if (p > 0) {
            form = (String)form + "." + Form.repeat("#", p);
        }
        DF = new DecimalFormat((String)form);
        return DF.format(i);
    }

    public static String fd(double i, int p) {
        Object form = "0";
        if (p > 0) {
            form = (String)form + "." + Form.repeat("0", p);
        }
        DF = new DecimalFormat((String)form);
        return DF.format(i);
    }

    public static String f(float i, int p) {
        Object form = "#";
        if (p > 0) {
            form = (String)form + "." + Form.repeat("#", p);
        }
        DF = new DecimalFormat((String)form);
        return DF.format(i);
    }

    public static String f(double i) {
        return Form.f(i, 1);
    }

    public static String f(float i) {
        return Form.f(i, 1);
    }

    public static String pc(double i, int p) {
        return Form.f(i * 100.0, p) + "%";
    }

    public static String pc(float i, int p) {
        return Form.f(i * 100.0f, p) + "%";
    }

    public static String pc(double i) {
        return Form.f(i * 100.0, 0) + "%";
    }

    public static String pc(float i) {
        return Form.f(i * 100.0f, 0) + "%";
    }

    public static String pc(int i, int of, int p) {
        return Form.f(100.0 * ((double)i / (double)of), p) + "%";
    }

    public static String pc(int i, int of) {
        return Form.pc(i, of, 0);
    }

    public static String pc(long i, long of, int p) {
        return Form.f(100.0 * ((double)i / (double)of), p) + "%";
    }

    public static String pc(long i, long of) {
        return Form.pc(i, of, 0);
    }

    public static String msSeconds(long ms) {
        return Form.f((double)ms / 1000.0);
    }

    public static String msSeconds(long ms, int p) {
        return Form.f((double)ms / 1000.0, p);
    }

    public static String nsMs(long ns) {
        return Form.f((double)ns / 1000000.0);
    }

    public static String nsMs(long ns, int p) {
        return Form.f((double)ns / 1000000.0, p);
    }

    public static String nsMsd(long ns, int p) {
        return Form.fd((double)ns / 1000000.0, p);
    }

    public static String toRoman(int num) {
        Object res = "";
        for (Map.Entry<String, Integer> entry : roman_numerals.entrySet()) {
            int matches = num / entry.getValue();
            res = (String)res + Form.repeat(entry.getKey(), matches);
            num %= entry.getValue().intValue();
        }
        return res;
    }

    public static int fromRoman(String number) {
        if (number.isEmpty()) {
            return 0;
        }
        if ((number = number.toUpperCase()).startsWith("M")) {
            return 1000 + Form.fromRoman(number.substring(1));
        }
        if (number.startsWith("CM")) {
            return 900 + Form.fromRoman(number.substring(2));
        }
        if (number.startsWith("D")) {
            return 500 + Form.fromRoman(number.substring(1));
        }
        if (number.startsWith("CD")) {
            return 400 + Form.fromRoman(number.substring(2));
        }
        if (number.startsWith("C")) {
            return 100 + Form.fromRoman(number.substring(1));
        }
        if (number.startsWith("XC")) {
            return 90 + Form.fromRoman(number.substring(2));
        }
        if (number.startsWith("L")) {
            return 50 + Form.fromRoman(number.substring(1));
        }
        if (number.startsWith("XL")) {
            return 40 + Form.fromRoman(number.substring(2));
        }
        if (number.startsWith("X")) {
            return 10 + Form.fromRoman(number.substring(1));
        }
        if (number.startsWith("IX")) {
            return 9 + Form.fromRoman(number.substring(2));
        }
        if (number.startsWith("V")) {
            return 5 + Form.fromRoman(number.substring(1));
        }
        if (number.startsWith("IV")) {
            return 4 + Form.fromRoman(number.substring(2));
        }
        if (number.startsWith("I")) {
            return 1 + Form.fromRoman(number.substring(1));
        }
        return 0;
    }

    public static String repeat(String s, int n) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    static {
        IBootstrap.dasBoot();
        NAMES = new String[]{"Thousand", "Million", "Billion", "Trillion", "Quadrillion", "Quintillion", "Sextillion", "Septillion", "Octillion", "Nonillion", "Decillion", "Undecillion", "Duodecillion", "Tredecillion", "Quattuordecillion", "Quindecillion", "Sexdecillion", "Septendecillion", "Octodecillion", "Novemdecillion", "Vigintillion"};
        THOUSAND = BigInteger.valueOf(1000L);
        roman_numerals = new LinkedHashMap();
        MAP = new TreeMap<BigInteger, String>();
        for (int i = 0; i < NAMES.length; ++i) {
            MAP.put(THOUSAND.pow(i + 1), NAMES[i]);
        }
        roman_numerals.put("M", 1000);
        roman_numerals.put("CM", 900);
        roman_numerals.put("D", 500);
        roman_numerals.put("CD", 400);
        roman_numerals.put("C", 100);
        roman_numerals.put("XC", 90);
        roman_numerals.put("L", 50);
        roman_numerals.put("XL", 40);
        roman_numerals.put("X", 10);
        roman_numerals.put("IX", 9);
        roman_numerals.put("V", 5);
        roman_numerals.put("IV", 4);
        roman_numerals.put("I", 1);
    }
}

