/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Area;
import com.volmit.adapt.util.VectorMath;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class Impulse {
    private final List<Entity> ignore = new ArrayList<Entity>();
    private double radius;
    private double forceMax;
    private double forceMin;
    private double damageMin;
    private double damageMax;

    public Impulse(double radius) {
        this.radius = radius;
        this.forceMax = 1.0;
        this.forceMin = 0.0;
        this.damageMax = 1.0;
        this.damageMin = 0.0;
    }

    public Impulse radius(double radius) {
        this.radius = radius;
        return this;
    }

    public Impulse force(double force) {
        this.forceMax = force;
        return this;
    }

    public Impulse force(double forceMax, double forceMin) {
        this.forceMax = forceMax;
        this.forceMin = forceMin;
        return this;
    }

    public Impulse damage(double damage) {
        this.damageMax = damage;
        return this;
    }

    public Impulse damage(double damageMax, double damageMin) {
        this.damageMax = damageMax;
        this.damageMin = damageMin;
        return this;
    }

    public void punch(Location at) {
        Area a2 = new Area(at, this.radius);
        for (Entity i : a2.getNearbyEntities()) {
            if (this.ignore.contains(i)) continue;
            Vector force = VectorMath.direction(at, i.getLocation());
            double damage = 0.0;
            double distance = i.getLocation().distance(at);
            if (this.forceMin < this.forceMax) {
                force.clone().multiply((1.0 - distance / this.radius) * (this.forceMax - this.forceMin) + this.forceMin);
            }
            if (this.damageMin < this.damageMax) {
                damage = (1.0 - distance / this.radius) * (this.damageMax - this.damageMin) + this.damageMin;
            }
            try {
                if (i instanceof LivingEntity && damage > 0.0) {
                    ((LivingEntity)i).damage(damage);
                }
                i.setVelocity(i.getVelocity().add(force));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Impulse ignore(Entity player) {
        this.ignore.add(player);
        return this;
    }

    static {
        IBootstrap.dasBoot();
    }
}

