/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class Items {
    public static boolean is(ItemStack is) {
        return is != null && !is.getType().equals((Object)Material.AIR);
    }

    public static boolean is(ItemStack is, Material material) {
        return Items.is(is) && is.getType().equals((Object)material);
    }

    public static boolean is(ItemStack is, MaterialBlock mb) {
        return Items.is(is, mb.getMaterial()) && is.getData().getData() == mb.getData().byteValue();
    }

    public static boolean is(ItemStack is, Material material, byte data) {
        return Items.is(is, new MaterialBlock(material, data));
    }

    public static boolean is(ItemStack is, Material material, int data) {
        return Items.is(is, material, (byte)data);
    }

    public static boolean hasMeta(ItemStack is) {
        return Items.is(is) && is.hasItemMeta();
    }

    public static boolean hasName(ItemStack is) {
        return Items.hasMeta(is) && is.getItemMeta().hasDisplayName();
    }

    public static boolean hasLore(ItemStack is) {
        return Items.hasMeta(is) && is.getItemMeta().hasLore();
    }

    public static boolean hasName(ItemStack is, String name) {
        return Items.hasName(is) && is.getItemMeta().getDisplayName().equals(name);
    }

    public static boolean hasEnchantment(ItemStack is, Enchantment e) {
        return Items.is(is) && is.getEnchantments().containsKey(e);
    }

    public static boolean hasEnchantment(ItemStack is, Enchantment e, int level) {
        if (!Items.is(is)) {
            return false;
        }
        return Items.hasEnchantment(is, e) && is.getEnchantmentLevel(e) == level;
    }

    public static boolean hasEnchantments(ItemStack is) {
        if (!Items.is(is)) {
            return false;
        }
        return !is.getEnchantments().isEmpty();
    }

    public static MaterialBlock toMaterialBlock(ItemStack is) {
        if (is != null) {
            return new MaterialBlock(is.getType(), is.getData().getData());
        }
        return null;
    }

    public static boolean isBroken(ItemStack is) {
        return Items.is(is) && Items.getMaxDurability(is) == Items.getDurability(is) && Items.hasDurability(is);
    }

    public static boolean hasDurability(ItemStack is) {
        return Items.is(is) && Items.getMaxDurability(is) > 0;
    }

    public static double getDurabilityPercent(ItemStack is) {
        if (!Items.is(is)) {
            return 0.0;
        }
        if (Items.getMaxDurability(is) == 0) {
            return 1.0;
        }
        return 1.0 - (double)Items.getDurability(is) / (double)Items.getMaxDurability(is);
    }

    public static void setDurabilityPercent(ItemStack is, double pc) {
        if (!Items.is(is)) {
            return;
        }
        double d = pc > 1.0 ? 1.0 : (pc = pc < 0.0 ? 0.0 : pc);
        if (Items.getDurability(is) == 0) {
            return;
        }
        Items.setDurability(is, (int)((double)Items.getMaxDurability(is) * (1.0 - pc)));
    }

    public static short getMaxDurability(ItemStack is) {
        if (!Items.is(is)) {
            return 0;
        }
        return is.getType().getMaxDurability();
    }

    public static short getDurability(ItemStack is) {
        if (!Items.is(is)) {
            return 0;
        }
        return is.getDurability();
    }

    public static void setDurability(ItemStack is, short dmg) {
        if (!Items.is(is)) {
            return;
        }
        is.setDurability(dmg > Items.getMaxDurability(is) ? Items.getMaxDurability(is) : dmg);
    }

    public static void setDurability(ItemStack is, int dmg) {
        if (!Items.is(is)) {
            return;
        }
        Items.setDurability(is, (short)dmg);
    }

    public static void damage(ItemStack is, int amt) {
        if (!Items.is(is)) {
            return;
        }
        Items.setDurability(is, Items.getDurability(is) + amt);
    }

    public static boolean isMergable(ItemStack a2, ItemStack b) {
        if (Items.is(a2) && Items.is(b)) {
            if (!a2.getType().equals((Object)b.getType())) {
                return false;
            }
            if (a2.getData().getData() != b.getData().getData()) {
                return false;
            }
            if (a2.hasItemMeta() != b.hasItemMeta()) {
                return false;
            }
            if (a2.getDurability() != b.getDurability()) {
                return false;
            }
            if (a2.hasItemMeta()) {
                if (!a2.getItemMeta().getDisplayName().equals(b.getItemMeta().getDisplayName())) {
                    return false;
                }
                if (!new ArrayList(a2.getItemMeta().getLore()).equals(new ArrayList(b.getItemMeta().getLore()))) {
                    return false;
                }
            }
            return a2.getMaxStackSize() >= a2.getAmount() + b.getAmount();
        }
        return false;
    }

    static {
        IBootstrap.dasBoot();
    }
}

