/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import com.volmit.adapt.util.secret.SecretSplash;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;

public class Localizer {
    public static void updateLanguageFile() {
        if (AdaptConfig.get().isAutoUpdateLanguage()) {
            Adapt.verbose("Attempting to update Language File");
            File langFolder = new File(Adapt.instance.getDataFolder() + "/languages");
            if (!langFolder.exists()) {
                langFolder.mkdir();
            }
            File langFile = new File(langFolder, AdaptConfig.get().getLanguage() + ".json");
            Adapt.verbose("Updating Primary Language File: " + AdaptConfig.get().getLanguage());
            InputStream in = Adapt.instance.getResource(AdaptConfig.get().getLanguage() + ".json");
            Files.deleteIfExists(langFile.toPath());
            Files.copy(in, langFile.toPath(), new CopyOption[0]);
            Adapt.verbose("Loaded Primary Language: " + AdaptConfig.get().getLanguage());
            if (!Objects.equals(AdaptConfig.get().getLanguage(), AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing())) {
                Adapt.verbose("Updating Fallback Language File: " + AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing());
                File langFileFallback = new File(langFolder, AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing() + ".json");
                InputStream inFB = Adapt.instance.getResource(AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing() + ".json");
                Files.deleteIfExists(langFileFallback.toPath());
                Files.copy(inFB, langFileFallback.toPath(), new CopyOption[0]);
                Adapt.verbose("Loaded Fallback: " + AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing());
            }
        } else {
            Adapt.error("Auto Update Language is disabled, Expect Errors.");
            Adapt.error("Do not disable this unless you know what you are doing, and dont expect support.");
        }
    }

    public static String dLocalize(String s1, String s2, String s3) {
        if (!Adapt.wordKey.containsKey(s1 + s2 + s3)) {
            File langFile = new File(Adapt.instance.getDataFolder() + "/languages", AdaptConfig.get().getLanguage() + ".json");
            String jsonFromFile = Files.readString(langFile.toPath());
            JsonElement jsonElement = JsonParser.parseString((String)jsonFromFile);
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            if (jsonObj.get(s1) == null || jsonObj.get(s1).getAsJsonObject().get(s2) == null || jsonObj.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3) == null || jsonObj.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3).getAsString() == null) {
                Localizer.updateLanguageFile();
                if (jsonObj.get(s1) == null || jsonObj.get(s1).getAsJsonObject().get(s2) == null || jsonObj.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3) == null || jsonObj.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3).getAsString() == null) {
                    Adapt.verbose("Your Language File is missing the following key: " + s1 + "." + s2 + "." + s3);
                    Adapt.verbose("Loading English Language File FallBack");
                    File langFileFallback = new File(Adapt.instance.getDataFolder() + "/languages", AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing() + ".json");
                    String jsonFromFileFallback = Files.readString(langFileFallback.toPath());
                    JsonElement jsonElementFallback = JsonParser.parseString((String)jsonFromFileFallback);
                    JsonObject jsonObjFallback = jsonElementFallback.getAsJsonObject();
                    if (jsonObjFallback.get(s1) == null || jsonObjFallback.get(s1).getAsJsonObject().get(s2) == null || jsonObjFallback.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3) == null || jsonObjFallback.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3).getAsString() == null) {
                        String f = SecretSplash.randomString7();
                        Adapt.wordKey.put(s1 + s2 + s3, f);
                        Adapt.error("Your Fallback Language File is missing the following key: " + s1 + "." + s2 + "." + s3);
                        Adapt.verbose("New Assignement: " + f);
                        Adapt.error("Please report this to the developer!");
                    } else {
                        Adapt.wordKey.put(s1 + s2 + s3, jsonObjFallback.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3).getAsString());
                        Adapt.verbose("Loaded Fallback: " + jsonObjFallback.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3).getAsString() + " for key: " + s1 + "." + s2 + "." + s3);
                    }
                }
            } else {
                Adapt.wordKey.put(s1 + s2 + s3, jsonObj.get(s1).getAsJsonObject().get(s2).getAsJsonObject().get(s3).getAsString());
            }
        }
        return Adapt.wordKey.get(s1 + s2 + s3);
    }

    static {
        IBootstrap.dasBoot();
    }
}

