/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.FastReflection;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public enum ParticleType {
    EXPLOSION_NORMAL("explode", "poof"),
    EXPLOSION_LARGE("largeexplode", "explosion"),
    EXPLOSION_HUGE("hugeexplosion", "explosion_emitter"),
    FIREWORKS_SPARK("fireworksSpark", "firework"),
    WATER_BUBBLE("bubble", "bubble"),
    WATER_SPLASH("splash", "splash"),
    WATER_WAKE("wake", "fishing"),
    SUSPENDED("suspended", "underwater"),
    SUSPENDED_DEPTH("depthsuspend", "underwater"),
    CRIT("crit", "crit"),
    CRIT_MAGIC("magicCrit", "enchanted_hit"),
    SMOKE_NORMAL("smoke", "smoke"),
    SMOKE_LARGE("largesmoke", "large_smoke"),
    SPELL("spell", "effect"),
    SPELL_INSTANT("instantSpell", "instant_effect"),
    SPELL_MOB("mobSpell", "entity_effect"),
    SPELL_MOB_AMBIENT("mobSpellAmbient", "ambient_entity_effect"),
    SPELL_WITCH("witchMagic", "witch"),
    DRIP_WATER("dripWater", "dripping_water"),
    DRIP_LAVA("dripLava", "dripping_lava"),
    VILLAGER_ANGRY("angryVillager", "angry_villager"),
    VILLAGER_HAPPY("happyVillager", "happy_villager"),
    TOWN_AURA("townaura", "mycelium"),
    NOTE("note", "note"),
    PORTAL("portal", "portal"),
    ENCHANTMENT_TABLE("enchantmenttable", "enchant"),
    FLAME("flame", "flame"),
    LAVA("lava", "lava"),
    CLOUD("cloud", "cloud"),
    REDSTONE("reddust", "dust"),
    SNOWBALL("snowballpoof", "item_snowball"),
    SNOW_SHOVEL("snowshovel", "item_snowball"),
    SLIME("slime", "item_slime"),
    HEART("heart", "heart"),
    ITEM_CRACK("iconcrack", "item"),
    BLOCK_CRACK("blockcrack", "block"),
    BLOCK_DUST("blockdust", "block"),
    BARRIER("barrier", "barrier", 8),
    WATER_DROP("droplet", "rain", 8),
    MOB_APPEARANCE("mobappearance", "elder_guardian", 8),
    DRAGON_BREATH("dragonbreath", "dragon_breath", 9),
    END_ROD("endRod", "end_rod", 9),
    DAMAGE_INDICATOR("damageIndicator", "damage_indicator", 9),
    SWEEP_ATTACK("sweepAttack", "sweep_attack", 9),
    FALLING_DUST("fallingdust", "falling_dust", 10),
    TOTEM("totem", "totem_of_undying", 11),
    SPIT("spit", "spit", 11),
    SQUID_INK(13),
    BUBBLE_POP(13),
    CURRENT_DOWN(13),
    BUBBLE_COLUMN_UP(13),
    NAUTILUS(13),
    DOLPHIN(13),
    SNEEZE(14),
    CAMPFIRE_COSY_SMOKE(14),
    CAMPFIRE_SIGNAL_SMOKE(14),
    COMPOSTER(14),
    FLASH(14),
    FALLING_LAVA(14),
    LANDING_LAVA(14),
    FALLING_WATER(14),
    DRIPPING_HONEY(15),
    FALLING_HONEY(15),
    LANDING_HONEY(15),
    FALLING_NECTAR(15);

    private static final int SERVER_VERSION_ID;
    private final String legacyName;
    private final String name;
    private final int minimumVersion;

    private ParticleType(String legacyName, String name) {
        this(legacyName, name, -1);
    }

    private ParticleType(int minimumVersion) {
        this.legacyName = null;
        this.name = this.name().toLowerCase();
        this.minimumVersion = minimumVersion;
    }

    private ParticleType(String legacyName, String name, int minimumVersion) {
        this.legacyName = legacyName;
        this.name = name;
        this.minimumVersion = minimumVersion;
    }

    public static ParticleType getParticle(String particleName) {
        try {
            return ParticleType.valueOf(particleName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            for (ParticleType particle : ParticleType.values()) {
                if (particle.getName().equalsIgnoreCase(particleName)) {
                    return particle;
                }
                if (!particle.hasLegacyName() || !particle.getLegacyName().equalsIgnoreCase(particleName)) continue;
                return particle;
            }
            return null;
        }
    }

    public boolean hasLegacyName() {
        return this.legacyName != null;
    }

    public String getLegacyName() {
        if (!this.hasLegacyName()) {
            throw new IllegalStateException("Particle " + this.name() + " don't have legacy name");
        }
        return this.legacyName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupported() {
        return this.minimumVersion <= 0 || SERVER_VERSION_ID >= this.minimumVersion;
    }

    public Class<?> getDataType() {
        switch (this) {
            case ITEM_CRACK: {
                return ItemStack.class;
            }
            case BLOCK_CRACK: 
            case BLOCK_DUST: 
            case FALLING_DUST: {
                return MaterialData.class;
            }
            case REDSTONE: {
                return Color.class;
            }
        }
        return Void.class;
    }

    static {
        IBootstrap.dasBoot();
        String ver = FastReflection.VERSION;
        SERVER_VERSION_ID = ver.charAt(4) == '_' ? Character.getNumericValue(ver.charAt(3)) : Integer.parseInt(ver.substring(3, 5));
    }
}

