/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public class PrecisionStopwatch {
    private long nanos;
    private long startNano;
    private long millis;
    private long startMillis;
    private double time;
    private boolean profiling;

    public PrecisionStopwatch() {
        this.reset();
        this.profiling = false;
    }

    public static PrecisionStopwatch start() {
        PrecisionStopwatch p = new PrecisionStopwatch();
        p.begin();
        return p;
    }

    public void begin() {
        this.profiling = true;
        this.startNano = System.nanoTime();
        this.startMillis = System.currentTimeMillis();
    }

    public void end() {
        if (!this.profiling) {
            return;
        }
        this.profiling = false;
        this.nanos = System.nanoTime() - this.startNano;
        this.millis = System.currentTimeMillis() - this.startMillis;
        this.time = (double)this.nanos / 1000000.0;
        this.time = (double)this.millis - this.time > 1.01 ? (double)this.millis : this.time;
    }

    public void reset() {
        this.nanos = -1L;
        this.millis = -1L;
        this.startNano = -1L;
        this.startMillis = -1L;
        this.time = 0.0;
        this.profiling = false;
    }

    public double getTicks() {
        return this.getMilliseconds() / 50.0;
    }

    public double getSeconds() {
        return this.getMilliseconds() / 1000.0;
    }

    public double getMinutes() {
        return this.getSeconds() / 60.0;
    }

    public double getHours() {
        return this.getMinutes() / 60.0;
    }

    public double getMilliseconds() {
        this.nanos = System.nanoTime() - this.startNano;
        this.millis = System.currentTimeMillis() - this.startMillis;
        this.time = (double)this.nanos / 1000000.0;
        this.time = (double)this.millis - this.time > 1.01 ? (double)this.millis : this.time;
        return this.time;
    }

    public long getNanoseconds() {
        return (long)(this.time * 1000000.0);
    }

    public long getNanos() {
        return this.nanos;
    }

    public long getStartNano() {
        return this.startNano;
    }

    public long getMillis() {
        return this.millis;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public double getTime() {
        return this.time;
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public void rewind(long l) {
        this.startMillis -= l;
    }

    static {
        IBootstrap.dasBoot();
    }
}

