/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Average;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;

public class RollingSequence
extends Average {
    private double median = 0.0;
    private double max = 0.0;
    private double min = 0.0;
    private boolean dirtyMedian;
    private int dirtyExtremes;
    private boolean precision;

    public RollingSequence(int size) {
        super(size);
        this.setPrecision(false);
    }

    public double addLast(int amt) {
        double f = 0.0;
        for (int i = 0; i < Math.min(this.values.length, amt); ++i) {
            f += this.values[i];
        }
        return f;
    }

    public boolean isPrecision() {
        return this.precision;
    }

    public void setPrecision(boolean p) {
        this.precision = p;
    }

    public double getMin() {
        if (this.dirtyExtremes > (this.isPrecision() ? 0 : this.values.length)) {
            this.resetExtremes();
        }
        return this.min;
    }

    public double getMax() {
        if (this.dirtyExtremes > (this.isPrecision() ? 0 : this.values.length)) {
            this.resetExtremes();
        }
        return this.max;
    }

    public double getMedian() {
        if (this.dirtyMedian) {
            this.recalculateMedian();
        }
        return this.median;
    }

    private void recalculateMedian() {
        this.median = (Double)XList.middleValue(XList.sort(XList.forceAdd(new ArrayList(), this.values)));
        this.dirtyMedian = false;
    }

    public void resetExtremes() {
        this.max = -2.147483648E9;
        this.min = 2.147483647E9;
        for (double i : this.values) {
            this.max = (Double)M.max((Number[])new Double[]{this.max, i});
            this.min = (Double)M.min((Number[])new Double[]{this.min, i});
        }
        this.dirtyExtremes = 0;
    }

    @Override
    public void put(double i) {
        super.put(i);
        this.dirtyMedian = true;
        ++this.dirtyExtremes;
        this.max = (Double)M.max((Number[])new Double[]{this.max, i});
        this.min = (Double)M.min((Number[])new Double[]{this.min, i});
    }

    static {
        IBootstrap.dasBoot();
    }
}

