/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Queue;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;

public class ShurikenQueue<T>
implements Queue<T> {
    private List<T> queue;
    private boolean randomPop;
    private boolean reversePop;

    public ShurikenQueue() {
        this.clear();
    }

    public ShurikenQueue<T> responsiveMode() {
        this.reversePop = true;
        return this;
    }

    public ShurikenQueue<T> randomMode() {
        this.randomPop = true;
        return this;
    }

    @Override
    public ShurikenQueue<T> queue(T t) {
        this.queue.add(t);
        return this;
    }

    @Override
    public ShurikenQueue<T> queue(List<T> t) {
        XList.add(this.queue, t);
        return this;
    }

    @Override
    public boolean hasNext(int amt) {
        return this.queue.size() >= amt;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        return this.reversePop ? XList.popLast(this.queue) : (this.randomPop ? XList.popRandom(this.queue) : XList.pop(this.queue));
    }

    @Override
    public List<T> next(int amt) {
        ArrayList<T> t = new ArrayList<T>();
        for (int i = 0; i < amt && this.hasNext(); ++i) {
            t.add(this.next());
        }
        return t;
    }

    @Override
    public ShurikenQueue<T> clear() {
        this.queue = new ArrayList<T>();
        return this;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean contains(T p) {
        return this.queue.contains(p);
    }

    static {
        IBootstrap.dasBoot();
    }
}

