/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.ChronoLatch;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.PrecisionStopwatch;
import com.volmit.adapt.util.RollingSequence;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public class ThreadMonitor
extends Thread {
    private final Thread monitor;
    private final ChronoLatch cl;
    private final RollingSequence sq = new RollingSequence(3);
    int cycles = 0;
    private boolean running = true;
    private Thread.State lastState;
    private PrecisionStopwatch st = PrecisionStopwatch.start();

    private ThreadMonitor(Thread monitor) {
        this.monitor = monitor;
        this.lastState = Thread.State.NEW;
        this.cl = new ChronoLatch(1000L);
        this.start();
    }

    public static ThreadMonitor bind(Thread monitor) {
        return new ThreadMonitor(monitor);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(0L);
                Thread.State s = this.monitor.getState();
                if (this.lastState != s) {
                    ++this.cycles;
                    this.pushState(s);
                }
                this.lastState = s;
                if (!this.cl.flip()) continue;
                Adapt.info("Cycles: " + Form.f(this.cycles) + " (" + Form.duration(this.sq.getAverage(), 2) + ")");
            }
            catch (Throwable e) {
                this.running = false;
                break;
            }
        }
    }

    public void pushState(Thread.State s) {
        if (s != Thread.State.RUNNABLE) {
            if (this.st != null) {
                this.sq.put(this.st.getMilliseconds());
            }
        } else {
            this.st = PrecisionStopwatch.start();
        }
    }

    public void unbind() {
        this.running = false;
    }

    static {
        IBootstrap.dasBoot();
    }
}

