/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.Callback;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.ElementEvent;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.UIVoidDecorator;
import com.volmit.adapt.util.Window;
import com.volmit.adapt.util.WindowDecorator;
import com.volmit.adapt.util.WindowResolution;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class UIWindow
implements Window,
Listener {
    private final Player viewer;
    private final Map<Integer, Element> elements;
    private WindowDecorator decorator;
    private Callback<Window> eClose;
    private WindowResolution resolution;
    private String title;
    private boolean visible;
    private int viewportPosition;
    private int viewportSize;
    private int highestRow;
    private String tag;
    private Inventory inventory;
    private int clickcheck = 0;
    private boolean doubleclicked = false;

    public UIWindow(Player viewer) {
        this.viewer = viewer;
        this.elements = new HashMap<Integer, Element>();
        this.setTitle("");
        this.setDecorator(new UIVoidDecorator());
        this.setResolution(WindowResolution.W9_H6);
        this.setViewportHeight(this.clip(3.0, 1.0, this.getResolution().getMaxHeight()).intValue());
        this.setViewportPosition(0);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        if (!e.getWhoClicked().equals(this.viewer)) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.viewer.getOpenInventory().getTitle().equals(this.title)) {
            return;
        }
        if (e.getClickedInventory() == null) {
            return;
        }
        if (!e.getView().getType().equals((Object)this.getResolution().getType())) {
            return;
        }
        if (e.getClickedInventory().getType().equals((Object)this.getResolution().getType())) {
            Element element = this.getElement(this.getLayoutPosition(e.getSlot()), this.getLayoutRow(e.getSlot()));
            switch (e.getAction()) {
                default: 
            }
            switch (e.getClick()) {
                case DOUBLE_CLICK: {
                    this.doubleclicked = true;
                    break;
                }
                case LEFT: {
                    ++this.clickcheck;
                    if (this.clickcheck == 1) {
                        J.s(() -> {
                            if (this.clickcheck == 1) {
                                this.clickcheck = 0;
                                if (element != null) {
                                    element.call(ElementEvent.LEFT, element);
                                }
                            }
                        });
                        break;
                    }
                    if (this.clickcheck != 2) break;
                    J.s(() -> {
                        if (this.doubleclicked) {
                            this.doubleclicked = false;
                        } else {
                            this.scroll(1);
                        }
                        this.clickcheck = 0;
                    });
                    break;
                }
                case RIGHT: {
                    if (element != null) {
                        element.call(ElementEvent.RIGHT, element);
                        break;
                    }
                    this.scroll(-1);
                    break;
                }
                case SHIFT_LEFT: {
                    if (element == null) break;
                    element.call(ElementEvent.SHIFT_LEFT, element);
                    break;
                }
                case SHIFT_RIGHT: {
                    if (element == null) break;
                    element.call(ElementEvent.SHIFT_RIGHT, element);
                    break;
                }
            }
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(InventoryCloseEvent e) {
        if (!e.getPlayer().equals(this.viewer)) {
            return;
        }
        if (!e.getPlayer().getOpenInventory().getTitle().equals(this.title)) {
            return;
        }
        if (this.isVisible()) {
            this.close();
            this.callClosed();
        }
    }

    @Override
    public WindowDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public UIWindow setDecorator(WindowDecorator decorator) {
        this.decorator = decorator;
        return this;
    }

    @Override
    public UIWindow close() {
        this.setVisible(false);
        return this;
    }

    @Override
    public UIWindow open() {
        this.setVisible(true);
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public UIWindow setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return this;
        }
        if (visible) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Adapt.instance);
            this.inventory = this.getResolution().getType().equals((Object)InventoryType.CHEST) ? Bukkit.createInventory(null, (int)(this.getViewportHeight() * 9), (String)this.getTitle()) : Bukkit.createInventory(null, (InventoryType)this.getResolution().getType(), (String)this.getTitle());
            this.viewer.openInventory(this.inventory);
            this.visible = visible;
            this.updateInventory();
        } else {
            this.visible = visible;
            HandlerList.unregisterAll((Listener)this);
            this.viewer.closeInventory();
        }
        this.visible = visible;
        return this;
    }

    @Override
    public int getViewportPosition() {
        return this.viewportPosition;
    }

    @Override
    public UIWindow setViewportPosition(int viewportPosition) {
        this.viewportPosition = viewportPosition;
        this.scroll(0);
        this.updateInventory();
        return this;
    }

    @Override
    public int getMaxViewportPosition() {
        return Math.max(0, this.highestRow - this.getViewportHeight());
    }

    @Override
    public UIWindow scroll(int direction) {
        this.viewportPosition = (int)this.clip(this.viewportPosition + direction, 0.0, this.getMaxViewportPosition()).doubleValue();
        this.updateInventory();
        return this;
    }

    @Override
    public int getViewportHeight() {
        return this.viewportSize;
    }

    @Override
    public UIWindow setViewportHeight(int height) {
        this.viewportSize = (int)this.clip(height, 1.0, this.getResolution().getMaxHeight()).doubleValue();
        if (this.isVisible()) {
            this.reopen();
        }
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public UIWindow setTitle(String title) {
        this.title = title;
        if (this.isVisible()) {
            this.reopen();
        }
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String s) {
        this.tag = s;
    }

    @Override
    public UIWindow setElement(int position, int row, Element e) {
        if (row > this.highestRow) {
            this.highestRow = row;
        }
        this.elements.put(this.getRealPosition((int)this.clip(position, -this.getResolution().getMaxWidthOffset(), this.getResolution().getMaxWidthOffset()).doubleValue(), row), e);
        this.updateInventory();
        return this;
    }

    @Override
    public Element getElement(int position, int row) {
        return this.elements.get(this.getRealPosition((int)this.clip(position, -this.getResolution().getMaxWidthOffset(), this.getResolution().getMaxWidthOffset()).doubleValue(), row));
    }

    @Override
    public Player getViewer() {
        return this.viewer;
    }

    @Override
    public UIWindow onClosed(Callback<Window> window) {
        this.eClose = window;
        return this;
    }

    @Override
    public int getViewportSlots() {
        return this.getViewportHeight() * this.getResolution().getWidth();
    }

    @Override
    public int getLayoutRow(int viewportSlottedPosition) {
        return this.getRow(this.getRealLayoutPosition(viewportSlottedPosition));
    }

    @Override
    public int getLayoutPosition(int viewportSlottedPosition) {
        return this.getPosition(viewportSlottedPosition);
    }

    @Override
    public int getRealLayoutPosition(int viewportSlottedPosition) {
        return this.getRealPosition(this.getPosition(viewportSlottedPosition), this.getRow(viewportSlottedPosition) + this.getViewportPosition());
    }

    @Override
    public int getRealPosition(int position, int row) {
        return (int)((double)(row * this.getResolution().getWidth() + this.getResolution().getMaxWidthOffset()) + this.clip(position, -this.getResolution().getMaxWidthOffset(), this.getResolution().getMaxWidthOffset()));
    }

    @Override
    public int getRow(int realPosition) {
        return realPosition / this.getResolution().getWidth();
    }

    @Override
    public int getPosition(int realPosition) {
        return realPosition % this.getResolution().getWidth() - this.getResolution().getMaxWidthOffset();
    }

    @Override
    public Window callClosed() {
        if (this.eClose != null) {
            this.eClose.run(this);
        }
        return this;
    }

    @Override
    public boolean hasElement(int position, int row) {
        return this.getElement(position, row) != null;
    }

    @Override
    public WindowResolution getResolution() {
        return this.resolution;
    }

    public Double clip(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    @Override
    public Window setResolution(WindowResolution resolution) {
        this.close();
        this.resolution = resolution;
        this.setViewportHeight((int)this.clip(this.getViewportHeight(), 1.0, this.getResolution().getMaxHeight()).doubleValue());
        return this;
    }

    @Override
    public Window clearElements() {
        this.highestRow = 0;
        this.elements.clear();
        this.updateInventory();
        return this;
    }

    @Override
    public Window updateInventory() {
        if (this.isVisible()) {
            ItemStack[] is = this.inventory.getContents();
            HashSet<ItemStack> isf = new HashSet<ItemStack>();
            for (int i = 0; i < is.length; ++i) {
                ItemStack isc = is[i];
                ItemStack isx = this.computeItemStack(i);
                int layoutRow = this.getLayoutRow(i);
                int layoutPosition = this.getLayoutPosition(i);
                if (isx != null && !this.hasElement(layoutPosition, layoutRow)) {
                    ItemStack gg = isx.clone();
                    gg.setAmount(gg.getAmount() + 1);
                    isf.add(gg);
                }
                if (isc == null == (isx == null) && (isx == null || isc == null || isc.equals((Object)isx))) continue;
                this.inventory.setItem(i, isx);
            }
        }
        return this;
    }

    @Override
    public ItemStack computeItemStack(int viewportSlot) {
        Element e;
        int layoutRow = this.getLayoutRow(viewportSlot);
        int layoutPosition = this.getLayoutPosition(viewportSlot);
        Element element = e = this.hasElement(layoutPosition, layoutRow) ? this.getElement(layoutPosition, layoutRow) : this.getDecorator().onDecorateBackground(this, layoutPosition, layoutRow);
        if (e != null) {
            return e.computeItemStack();
        }
        return null;
    }

    @Override
    public Window reopen() {
        return this.close().open();
    }

    static {
        IBootstrap.dasBoot();
    }
}

