/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Command;
import com.volmit.adapt.util.ICommand;
import com.volmit.adapt.util.MortarSender;
import com.volmit.adapt.util.V;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class VirtualCommand {
    private final ICommand command;
    private final String tag;
    private final Map<List<String>, VirtualCommand> children;

    public VirtualCommand(ICommand command) {
        this(command, "");
    }

    public VirtualCommand(ICommand command, String tag) {
        this.command = command;
        this.children = new HashMap<List<String>, VirtualCommand>();
        this.tag = tag;
        for (Field i : command.getClass().getDeclaredFields()) {
            if (!i.isAnnotationPresent(Command.class)) continue;
            try {
                Command cc = i.getAnnotation(Command.class);
                ICommand cmd = (ICommand)i.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                new V(command, true, true).set(i.getName(), cmd);
                this.children.put(cmd.getAllNodes(), new VirtualCommand(cmd, cc.value().trim().isEmpty() ? tag : cc.value().trim()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getTag() {
        return this.tag;
    }

    public ICommand getCommand() {
        return this.command;
    }

    public Map<List<String>, VirtualCommand> getChildren() {
        return this.children;
    }

    public boolean hit(CommandSender sender, List<String> chain) {
        return this.hit(sender, chain, null);
    }

    public boolean hit(CommandSender sender, List<String> chain, String label) {
        MortarSender vs = new MortarSender(sender);
        vs.setTag(this.tag);
        if (label != null) {
            vs.setCommand(label);
        }
        if (chain.isEmpty()) {
            if (!this.checkPermissions(sender, this.command)) {
                return true;
            }
            return this.command.handle(vs, new String[0]);
        }
        String nl = chain.get(0);
        for (List<String> i : XMap.k(this.children)) {
            for (String j : i) {
                if (!j.equalsIgnoreCase(nl)) continue;
                vs.setCommand(chain.get(0));
                VirtualCommand cmd = this.children.get(i);
                List<String> c = XList.copy(chain);
                c.remove(0);
                if (!cmd.hit(sender, c, vs.getCommand())) continue;
                if (vs.isPlayer()) {
                    vs.player().getWorld().playSound(vs.player().getLocation(), Sound.ITEM_AXE_STRIP, 0.35f, 1.8f);
                }
                return true;
            }
        }
        if (!this.checkPermissions(sender, this.command)) {
            return true;
        }
        return this.command.handle(vs, chain.toArray(new String[chain.size()]));
    }

    public List<String> hitTab(CommandSender sender, List<String> chain, String label) {
        MortarSender vs = new MortarSender(sender);
        vs.setTag(this.tag);
        if (label != null) {
            vs.setCommand(label);
        }
        if (chain.isEmpty()) {
            if (!this.checkPermissions(sender, this.command)) {
                return null;
            }
            return this.command.handleTab(vs, new String[0]);
        }
        String nl = chain.get(0);
        for (List<String> i : XMap.k(this.children)) {
            for (String j : i) {
                if (!j.equalsIgnoreCase(nl)) continue;
                vs.setCommand(chain.get(0));
                VirtualCommand cmd = this.children.get(i);
                List<String> c = XList.copy(chain);
                c.remove(0);
                List<String> v = cmd.hitTab(sender, c, vs.getCommand());
                if (v == null) continue;
                return v;
            }
        }
        if (!this.checkPermissions(sender, this.command)) {
            return null;
        }
        return this.command.handleTab(vs, chain.toArray(new String[chain.size()]));
    }

    private boolean checkPermissions(CommandSender sender, ICommand command2) {
        boolean failed = false;
        for (String i : this.command.getRequiredPermissions()) {
            if (sender.hasPermission(i)) continue;
            failed = true;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Adapt.instance, () -> Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "- " + C.WHITE + i), 0L);
        }
        if (failed) {
            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Insufficient Permissions");
            return false;
        }
        return true;
    }

    static {
        IBootstrap.dasBoot();
    }
}

