/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Objects;
import net.minecraft.resources.MinecraftKey;

public class NameKey {
    private final String namespace;
    private final String key;
    private transient MinecraftKey mcKey;

    public NameKey(String namespace, String key) {
        this.namespace = namespace.toLowerCase();
        this.key = key.toLowerCase();
    }

    public NameKey(String key) {
        String[] split = key.split(":");
        if (split.length < 2) {
            this.namespace = "minecraft";
            this.key = key.toLowerCase();
        } else {
            this.namespace = split[0].toLowerCase();
            this.key = key.replaceFirst(split[0] + ":", "").toLowerCase();
        }
    }

    public NameKey(MinecraftKey from) {
        this.namespace = from.b().toLowerCase();
        this.key = from.a().toLowerCase();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSimilar(NameKey anotherNameKey) {
        return this.namespace.equals(anotherNameKey.getNamespace()) && this.key.equals(anotherNameKey.getKey());
    }

    public MinecraftKey getMinecraftKey() {
        if (this.mcKey == null) {
            this.mcKey = new MinecraftKey(this.namespace, this.key);
        }
        return this.mcKey;
    }

    public boolean equals(Object obj) {
        return this.isSimilar((NameKey)obj);
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.key);
    }

    static {
        IBootstrap.dasBoot();
    }
}

