/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementReward;
import com.volmit.adapt.util.advancements.advancement.ToastNotification;
import com.volmit.adapt.util.advancements.advancement.criteria.Criteria;
import com.volmit.adapt.util.advancements.advancement.progress.AdvancementProgress;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Advancement {
    private final NameKey name;
    private final AdvancementDisplay display;
    private final Advancement parent;
    private final boolean childrenTracked;
    private final List<AdvancementFlag> flags;
    private final HashSet<Advancement> children = new HashSet();
    private final HashMap<String, AdvancementProgress> progressMap = new HashMap();
    private Criteria criteria = new Criteria(1);
    private AdvancementReward reward;
    private HashMap<String, Boolean> savedVisibilityStatus;

    public Advancement(@Nullable Advancement parent, NameKey name, AdvancementDisplay display, AdvancementFlag ... flags) {
        this.parent = parent;
        this.childrenTracked = true;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = name;
        this.display = display;
        this.flags = Arrays.asList(flags);
    }

    public Advancement(@Nullable Advancement parent, NameKey name, AdvancementDisplay display, boolean childrenTracking, AdvancementFlag ... flags) {
        this.parent = null;
        this.childrenTracked = childrenTracking;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = name;
        this.display = display;
        this.flags = Arrays.asList(flags);
    }

    public Advancement(NameKey name, AdvancementDisplay display, AdvancementFlag ... flags) {
        this.parent = null;
        this.childrenTracked = true;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = name;
        this.display = display;
        this.flags = Arrays.asList(flags);
    }

    public Advancement(NameKey name, AdvancementDisplay display, boolean childrenTracking, AdvancementFlag ... flags) {
        this.parent = null;
        this.childrenTracked = childrenTracking;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = name;
        this.display = display;
        this.flags = Arrays.asList(flags);
    }

    public NameKey getName() {
        return this.name;
    }

    public boolean hasName(NameKey key) {
        return key.getNamespace().equalsIgnoreCase(this.name.getNamespace()) && key.getKey().equalsIgnoreCase(this.name.getKey());
    }

    public AdvancementDisplay getDisplay() {
        return this.display;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
        this.progressMap.clear();
    }

    public AdvancementReward getReward() {
        return this.reward;
    }

    public void setReward(AdvancementReward reward) {
        this.reward = reward;
    }

    public Advancement getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    private void addChild(Advancement adv) {
        if (adv.getParent() == this && this.childrenTracked) {
            this.children.add(adv);
        }
    }

    public HashSet<Advancement> getChildren() {
        return new HashSet<Advancement>(this.children);
    }

    public Advancement getRootAdvancement() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootAdvancement();
    }

    public NameKey getTab() {
        return this.getRootAdvancement().getName();
    }

    public List<Advancement> getRow() {
        ArrayList<Advancement> row = new ArrayList<Advancement>();
        row.add(this);
        if (this.getParent() != null) {
            for (Advancement untilRow : this.getParent().getRowUntil()) {
                if (row.contains(untilRow)) continue;
                row.add(untilRow);
            }
            Collections.reverse(row);
        }
        for (Advancement child : this.getChildren()) {
            for (Advancement afterRow : child.getRowAfter()) {
                if (row.contains(afterRow)) continue;
                row.add(afterRow);
            }
        }
        return row;
    }

    public List<Advancement> getRowUntil() {
        ArrayList<Advancement> row = new ArrayList<Advancement>();
        row.add(this);
        if (this.getParent() != null) {
            for (Advancement untilRow : this.getParent().getRowUntil()) {
                if (row.contains(untilRow)) continue;
                row.add(untilRow);
            }
        }
        return row;
    }

    public List<Advancement> getRowAfter() {
        ArrayList<Advancement> row = new ArrayList<Advancement>();
        row.add(this);
        for (Advancement child : this.getChildren()) {
            for (Advancement afterRow : child.getRowAfter()) {
                if (row.contains(afterRow)) continue;
                row.add(afterRow);
            }
        }
        return row;
    }

    public boolean isAnythingGrantedUntil(Player player) {
        for (Advancement until : this.getRowUntil()) {
            if (!until.isGranted(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnythingGrantedAfter(Player player) {
        for (Advancement after : this.getRowAfter()) {
            if (!after.isGranted(player)) continue;
            return true;
        }
        return false;
    }

    public AdvancementProgress getProgress(Player player) {
        return this.getProgress(player.getUniqueId());
    }

    public AdvancementProgress getProgress(UUID uuid) {
        if (uuid == null) {
            Adapt.error("AdvancementProgress.getProgress(UUID) was called with a null UUID!");
            return null;
        }
        if (!this.progressMap.containsKey(uuid.toString())) {
            this.progressMap.put(uuid.toString(), new AdvancementProgress(this.getCriteria().getCriteria(), this.getCriteria().getRequirements()));
        }
        return this.progressMap.get(uuid.toString());
    }

    public void unloadProgress(Player player) {
        this.unloadProgress(player.getUniqueId());
    }

    public void unloadProgress(UUID uuid) {
        this.progressMap.remove(uuid.toString());
    }

    public boolean isGranted(Player player) {
        return this.getProgress(player).isDone();
    }

    public boolean isGranted(UUID uuid) {
        return this.getProgress(uuid).isDone();
    }

    public List<AdvancementFlag> getFlags() {
        return new ArrayList<AdvancementFlag>(this.flags);
    }

    public boolean hasFlag(AdvancementFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public void saveVisibilityStatus(Player player, boolean visible) {
        if (this.savedVisibilityStatus == null) {
            this.savedVisibilityStatus = new HashMap();
        }
        this.savedVisibilityStatus.put(player.getUniqueId().toString(), visible);
    }

    public boolean getVisibilityStatus(Player player) {
        if (this.savedVisibilityStatus == null) {
            this.savedVisibilityStatus = new HashMap();
        }
        if (!this.savedVisibilityStatus.containsKey(player.getUniqueId().toString())) {
            this.savedVisibilityStatus.put(player.getUniqueId().toString(), this.getDisplay().isVisible(player, this));
        }
        return this.savedVisibilityStatus.get(player.getUniqueId().toString());
    }

    public void unloadVisibilityStatus(Player player) {
        if (this.savedVisibilityStatus == null) {
            return;
        }
        this.savedVisibilityStatus.remove(player.getUniqueId().toString());
    }

    public void unloadVisibilityStatus(UUID uuid) {
        this.savedVisibilityStatus.remove(uuid.toString());
    }

    public ToastNotification getToastNotification() {
        ToastNotification notification = new ToastNotification(this.getDisplay().getIcon(), this.getDisplay().getTitle(), this.getDisplay().getFrame());
        return notification;
    }

    public void displayToast(Player player) {
        ToastNotification notification = this.getToastNotification();
        notification.send(player);
    }

    public BaseComponent getMessage(Player player) {
        String translation = "chat.type.advancement." + this.display.getFrame().name().toLowerCase();
        boolean challenge = this.getDisplay().getFrame() == AdvancementDisplay.AdvancementFrame.CHALLENGE;
        TranslatableComponent message = new TranslatableComponent();
        message.setTranslate(translation);
        TextComponent playerNameText = new TextComponent(player.getDisplayName());
        TextComponent title = new TextComponent("[");
        title.addExtra(this.display.getTitle().getJson());
        title.addExtra("]");
        title.setColor(challenge ? ChatColor.DARK_PURPLE : ChatColor.GREEN);
        TextComponent titleTextComponent = new TextComponent(new BaseComponent[]{this.display.getTitle().getJson()});
        titleTextComponent.setColor(title.getColor());
        Text titleText = new Text(new BaseComponent[]{titleTextComponent});
        Text descriptionText = new Text(new BaseComponent[]{this.display.getDescription().getJson()});
        title.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{titleText, new Text("\n"), descriptionText}));
        message.setWith(Arrays.asList(playerNameText, title));
        return message;
    }

    public void displayMessageToEverybody(Player player) {
        BaseComponent message = this.getMessage(player);
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.spigot().sendMessage(ChatMessageType.CHAT, message);
        }
    }

    public boolean equals(Object obj) {
        return this.getName().equals(((Advancement)obj).getName());
    }

    static {
        IBootstrap.dasBoot();
    }
}

