/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.util.advancements.JSONMessage;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.advancements.AdvancementFrameType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdvancementDisplay {
    private ItemStack icon;
    private JSONMessage title;
    private JSONMessage description;
    private AdvancementFrame frame;
    private transient AdvancementVisibility vis;
    private String backgroundTexture;
    private float x = 0.0f;
    private float y = 0.0f;
    private Advancement positionOrigin;

    public AdvancementDisplay(Material icon, JSONMessage title, JSONMessage description, AdvancementFrame frame, AdvancementVisibility visibility) {
        this.icon = new ItemStack(icon);
        this.title = title;
        this.description = description;
        this.frame = frame;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(Material icon, String title, String description, AdvancementFrame frame, AdvancementVisibility visibility) {
        this.icon = new ItemStack(icon);
        TextComponent titleComponent = new TextComponent(title);
        this.title = new JSONMessage((BaseComponent)titleComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(description));
        this.frame = frame;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(Material icon, JSONMessage title, JSONMessage description, AdvancementFrame frame, String backgroundTexture, AdvancementVisibility visibility) {
        this.icon = new ItemStack(icon);
        this.title = title;
        this.description = description;
        this.frame = frame;
        this.backgroundTexture = backgroundTexture;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(Material icon, String title, String description, AdvancementFrame frame, String backgroundTexture, AdvancementVisibility visibility) {
        this.icon = new ItemStack(icon);
        TextComponent titleComponent = new TextComponent(title);
        this.title = new JSONMessage((BaseComponent)titleComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(description));
        this.frame = frame;
        this.backgroundTexture = backgroundTexture;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(ItemStack icon, JSONMessage title, JSONMessage description, AdvancementFrame frame, AdvancementVisibility visibility) {
        this.icon = icon;
        this.title = title;
        this.description = description;
        this.frame = frame;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(ItemStack icon, String title, String description, AdvancementFrame frame, AdvancementVisibility visibility) {
        this.icon = icon;
        TextComponent titleComponent = new TextComponent(title);
        this.title = new JSONMessage((BaseComponent)titleComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(description));
        this.frame = frame;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(ItemStack icon, JSONMessage title, JSONMessage description, AdvancementFrame frame, String backgroundTexture, AdvancementVisibility visibility) {
        this.icon = icon;
        this.title = title;
        this.description = description;
        this.frame = frame;
        this.backgroundTexture = backgroundTexture;
        this.setVisibility(visibility);
    }

    public AdvancementDisplay(ItemStack icon, String title, String description, AdvancementFrame frame, String backgroundTexture, AdvancementVisibility visibility) {
        this.icon = icon;
        TextComponent titleComponent = new TextComponent(title);
        this.title = new JSONMessage((BaseComponent)titleComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(description));
        this.frame = frame;
        this.backgroundTexture = backgroundTexture;
        this.setVisibility(visibility);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(Material icon) {
        this.icon = new ItemStack(icon);
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public JSONMessage getTitle() {
        return this.title;
    }

    public void setTitle(JSONMessage title) {
        this.title = title;
    }

    public void setTitle(String title) {
        TextComponent titleComponent = new TextComponent(title);
        this.title = new JSONMessage((BaseComponent)titleComponent);
    }

    public JSONMessage getDescription() {
        return this.description;
    }

    public void setDescription(JSONMessage description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = new JSONMessage((BaseComponent)new TextComponent(description));
    }

    public AdvancementFrame getFrame() {
        return this.frame;
    }

    public void setFrame(AdvancementFrame frame) {
        this.frame = frame;
    }

    @Nullable
    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTexture(@Nullable String backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float generateX() {
        if (this.getPositionOrigin() == null) {
            return this.x;
        }
        return this.getPositionOrigin().getDisplay().generateX() + this.x;
    }

    public float generateY() {
        if (this.getPositionOrigin() == null) {
            return this.y;
        }
        return this.getPositionOrigin().getDisplay().generateY() + this.y;
    }

    public AdvancementVisibility getVisibility() {
        return this.vis != null ? this.vis : AdvancementVisibility.VANILLA;
    }

    public void setVisibility(AdvancementVisibility visibility) {
        this.vis = visibility;
    }

    public boolean isVisible(Player player, Advancement advancement) {
        AdvancementVisibility visibility = this.getVisibility();
        Advancement parent = advancement.getParent();
        boolean parentVisible = parent == null || parent.getDisplay().isVisible(player, parent);
        return parentVisible && visibility.isVisible(player, advancement) || advancement.isGranted(player) || visibility.isAlwaysVisibleWhenAnyChildIsGranted() && advancement.isAnythingGrantedAfter(player);
    }

    public Advancement getPositionOrigin() {
        return this.positionOrigin;
    }

    public void setPositionOrigin(@Nullable Advancement positionOrigin) {
        this.positionOrigin = positionOrigin;
    }

    public void setCoordinates(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    static {
        IBootstrap.dasBoot();
    }

    public static enum AdvancementFrame {
        TASK(AdvancementFrameType.a),
        GOAL(AdvancementFrameType.c),
        CHALLENGE(AdvancementFrameType.b);

        private final AdvancementFrameType nms;

        private AdvancementFrame(AdvancementFrameType nms) {
            this.nms = nms;
        }

        public static AdvancementFrame parse(String name) {
            for (AdvancementFrame frame : AdvancementFrame.values()) {
                if (!frame.name().equalsIgnoreCase(name)) continue;
                return frame;
            }
            return TASK;
        }

        public static AdvancementFrame parseStrict(String name) {
            for (AdvancementFrame frame : AdvancementFrame.values()) {
                if (!frame.name().equalsIgnoreCase(name)) continue;
                return frame;
            }
            return null;
        }

        public AdvancementFrameType getNMS() {
            return this.nms;
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

