/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement.criteria;

import com.volmit.adapt.util.advancements.CrazyAdvancementsAPI;
import com.volmit.adapt.util.advancements.advancement.criteria.CriteriaType;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.advancements.Criterion;

public class Criteria {
    private final CriteriaType type;
    private final int requiredNumber;
    private final String[] actionNames;
    private final String[][] requirements;
    private final HashMap<String, Criterion> criteria = new HashMap();

    public Criteria(int requiredNumber) {
        this.type = CriteriaType.NUMBER;
        this.requiredNumber = requiredNumber;
        this.actionNames = new String[requiredNumber];
        for (int i = 0; i < requiredNumber; ++i) {
            this.criteria.put("" + i, CrazyAdvancementsAPI.CRITERION);
            this.actionNames[i] = "" + i;
        }
        ArrayList<String[]> fixedRequirements = new ArrayList<String[]>();
        for (String name : this.criteria.keySet()) {
            fixedRequirements.add(new String[]{name});
        }
        this.requirements = (String[][])Arrays.stream(fixedRequirements.toArray()).toArray(x$0 -> new String[x$0][]);
    }

    public Criteria(String[] actionNames, String[][] requirements) {
        this.type = CriteriaType.LIST;
        this.requiredNumber = -1;
        this.actionNames = actionNames;
        this.requirements = requirements;
        for (String action : actionNames) {
            this.criteria.put(action, CrazyAdvancementsAPI.CRITERION);
        }
    }

    public CriteriaType getType() {
        return this.type;
    }

    public int getRequiredNumber() {
        return this.requiredNumber;
    }

    public String[] getActionNames() {
        return this.actionNames;
    }

    public String[][] getRequirements() {
        return this.requirements;
    }

    public HashMap<String, Criterion> getCriteria() {
        return new HashMap<String, Criterion>(this.criteria);
    }

    static {
        IBootstrap.dasBoot();
    }
}

