/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.command;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProgressChangeOperation {
    SET{

        @Override
        public int apply(int base, int amount) {
            return amount;
        }
    }
    ,
    ADD{

        @Override
        public int apply(int base, int amount) {
            return base + amount;
        }
    }
    ,
    REMOVE{

        @Override
        public int apply(int base, int amount) {
            return base - amount;
        }
    }
    ,
    MULTIPLY{

        @Override
        public int apply(int base, int amount) {
            return base * amount;
        }
    }
    ,
    DIVIDE{

        @Override
        public int apply(int base, int amount) {
            return (int)Math.floor((double)base * 1.0 / (double)amount);
        }
    }
    ,
    POWER{

        @Override
        public int apply(int base, int amount) {
            return (int)Math.pow(base, amount);
        }
    };


    public static ProgressChangeOperation parse(String input) {
        for (ProgressChangeOperation op : ProgressChangeOperation.values()) {
            if (!op.name().equalsIgnoreCase(input)) continue;
            return op;
        }
        return SET;
    }

    public abstract int apply(int var1, int var2);

    static {
        IBootstrap.dasBoot();
    }
}

