/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.manager;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.volmit.adapt.util.advancements.CrazyAdvancementsAPI;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementReward;
import com.volmit.adapt.util.advancements.advancement.criteria.CriteriaType;
import com.volmit.adapt.util.advancements.advancement.progress.AdvancementProgress;
import com.volmit.adapt.util.advancements.advancement.progress.GenericResult;
import com.volmit.adapt.util.advancements.advancement.progress.GrantCriteriaResult;
import com.volmit.adapt.util.advancements.advancement.progress.SetCriteriaResult;
import com.volmit.adapt.util.advancements.event.AdvancementGrantEvent;
import com.volmit.adapt.util.advancements.event.AdvancementRevokeEvent;
import com.volmit.adapt.util.advancements.packet.AdvancementsPacket;
import com.volmit.adapt.util.advancements.packet.PacketConverter;
import com.volmit.adapt.util.advancements.save.CriteriaData;
import com.volmit.adapt.util.advancements.save.ProgressData;
import com.volmit.adapt.util.advancements.save.SaveFile;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class AdvancementManager {
    private static final HashMap<String, AdvancementManager> accessibleManagers;
    private final NameKey name;
    private final ArrayList<Player> players;
    private final ArrayList<Advancement> advancements = new ArrayList();

    public AdvancementManager(NameKey name, Player ... players) {
        this.name = name;
        this.players = new ArrayList();
        for (Player player : players) {
            this.addPlayer(player);
        }
    }

    public static AdvancementManager getAccessibleManager(NameKey name) {
        return accessibleManagers.getOrDefault(name.toString(), null);
    }

    public static Collection<AdvancementManager> getAccessibleManagers() {
        return accessibleManagers.values();
    }

    private static boolean isOnline(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return player != null && player.isOnline();
    }

    private static SaveFile generateSaveFile(File file) {
        if (file.exists() && file.isFile()) {
            FileReader os = null;
            try {
                os = new FileReader(file);
                JsonElement element = JsonParser.parseReader((Reader)os);
                os.close();
                return SaveFile.fromJSON(element);
            }
            catch (Exception ex) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                System.err.println("Unable to read Save File!");
                ex.printStackTrace();
            }
        }
        return new SaveFile(new ArrayList<ProgressData>(), new ArrayList<CriteriaData>());
    }

    public NameKey getName() {
        return this.name;
    }

    public void addPlayer(Player player) {
        if (player == null) {
            throw new RuntimeException("Player may not be null");
        }
        if (!this.players.contains(player)) {
            this.players.add(player);
        }
        ArrayList<Advancement> advancements = new ArrayList<Advancement>();
        for (Advancement advancement : this.getAdvancements()) {
            AdvancementDisplay display = advancement.getDisplay();
            boolean visible = display.isVisible(player, advancement);
            advancement.saveVisibilityStatus(player, visible);
            if (!visible) continue;
            advancements.add(advancement);
        }
        AdvancementsPacket packet = new AdvancementsPacket(player, false, advancements, null);
        packet.send();
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
        ArrayList<NameKey> removedAdvancements = new ArrayList<NameKey>();
        for (Advancement advancement : this.getAdvancements()) {
            removedAdvancements.add(advancement.getName());
        }
        AdvancementsPacket packet = new AdvancementsPacket(player, false, null, removedAdvancements);
        packet.send();
    }

    public ArrayList<Player> getPlayers() {
        this.players.removeIf(p -> p == null || !p.isOnline());
        return this.players;
    }

    public void addAdvancement(Advancement ... addedAdvancements) {
        ArrayList<Advancement> nonDuplicates = new ArrayList<Advancement>();
        for (Advancement advancement : addedAdvancements) {
            if (this.advancements.contains(advancement)) continue;
            this.advancements.add(advancement);
            nonDuplicates.add(advancement);
        }
        HashSet<NameKey> updatedTabs = new HashSet<NameKey>();
        for (Advancement adv : nonDuplicates) {
            float smallestX = PacketConverter.getSmallestX(adv.getTab());
            float x = adv.getDisplay().generateX();
            if (x < smallestX) {
                smallestX = x;
                updatedTabs.add(adv.getTab());
                PacketConverter.setSmallestX(adv.getTab(), smallestX);
            }
            float smallestY = PacketConverter.getSmallestY(adv.getTab());
            float y = adv.getDisplay().generateY();
            if (!(y < smallestY)) continue;
            smallestY = y;
            updatedTabs.add(adv.getTab());
            PacketConverter.setSmallestY(adv.getTab(), smallestY);
        }
        for (NameKey tab : updatedTabs) {
            for (Player player : this.getPlayers()) {
                this.updateTab(player, tab);
            }
        }
        for (Player player : this.getPlayers()) {
            ArrayList<Advancement> advancements = new ArrayList<Advancement>();
            for (Advancement advancement : nonDuplicates) {
                AdvancementDisplay display = advancement.getDisplay();
                boolean visible = display.isVisible(player, advancement);
                advancement.saveVisibilityStatus(player, visible);
                if (!visible) continue;
                advancements.add(advancement);
            }
            AdvancementsPacket packet = new AdvancementsPacket(player, false, advancements, null);
            packet.send();
        }
    }

    public void updateAdvancement(Advancement ... updatedAdvancements) {
        HashSet<NameKey> updatedTabs = new HashSet<NameKey>();
        ArrayList<Advancement> remainingAdvancements = new ArrayList<Advancement>();
        ArrayList<NameKey> remainingNames = new ArrayList<NameKey>();
        for (Advancement advancement : updatedAdvancements) {
            boolean updated = false;
            float smallestX = PacketConverter.getSmallestX(advancement.getTab());
            float x = advancement.getDisplay().generateX();
            if (x < smallestX) {
                updated = true;
                smallestX = x;
                updatedTabs.add(advancement.getTab());
                PacketConverter.setSmallestX(advancement.getTab(), smallestX);
            }
            float smallestY = PacketConverter.getSmallestY(advancement.getTab());
            float y = advancement.getDisplay().generateY();
            if (y < smallestY) {
                updated = true;
                smallestY = y;
                updatedTabs.add(advancement.getTab());
                PacketConverter.setSmallestY(advancement.getTab(), smallestY);
            }
            if (updated) continue;
            remainingAdvancements.add(advancement);
        }
        for (NameKey tab : updatedTabs) {
            for (Player player : this.getPlayers()) {
                this.updateTab(player, tab);
            }
        }
        if (remainingAdvancements.size() > 0) {
            for (Player player : this.getPlayers()) {
                NameKey activeTab = CrazyAdvancementsAPI.getActiveTab(player);
                CrazyAdvancementsAPI.clearActiveTab(player);
                AdvancementsPacket packet = new AdvancementsPacket(player, false, remainingAdvancements, remainingNames);
                packet.send();
                CrazyAdvancementsAPI.setActiveTab(player, activeTab);
            }
        }
    }

    public void removeAdvancement(Advancement ... removedAdvancements) {
        ArrayList<NameKey> nonDuplicates = new ArrayList<NameKey>();
        for (Advancement advancement : removedAdvancements) {
            if (!this.advancements.contains(advancement)) continue;
            this.advancements.remove(advancement);
            nonDuplicates.add(advancement.getName());
        }
        for (Player player : this.getPlayers()) {
            AdvancementsPacket packet = new AdvancementsPacket(player, false, null, nonDuplicates);
            packet.send();
        }
    }

    public ArrayList<Advancement> getAdvancements() {
        return new ArrayList<Advancement>(this.advancements);
    }

    public ArrayList<Advancement> getAdvancements(String namespace) {
        ArrayList<Advancement> advs = this.getAdvancements();
        advs.removeIf(adv -> !adv.getName().getNamespace().equalsIgnoreCase(namespace));
        return advs;
    }

    public Advancement getAdvancement(NameKey name) {
        for (Advancement advancement : this.advancements) {
            if (!advancement.hasName(name)) continue;
            return advancement;
        }
        return null;
    }

    public void makeAccessible() {
        if (accessibleManagers.containsKey(this.name.toString())) {
            throw new RuntimeException("There is already an AdvancementManager with Name '" + this.name + "'!");
        }
        if (accessibleManagers.containsValue(this)) {
            throw new RuntimeException("AdvancementManager is already accessible!");
        }
        accessibleManagers.put(this.name.toString(), this);
    }

    public void resetAccessible() {
        Iterator<String> it = accessibleManagers.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (!accessibleManagers.get(name).equals(this)) continue;
            it.remove();
            break;
        }
    }

    public void updateTab(Player player, NameKey tab) {
        ArrayList<Advancement> advancements = new ArrayList<Advancement>();
        ArrayList<NameKey> names = new ArrayList<NameKey>();
        for (Advancement advancement : this.getAdvancements()) {
            if (!advancement.getTab().isSimilar(tab) || !advancement.getDisplay().isVisible(player, advancement)) continue;
            advancements.add(advancement);
            names.add(advancement.getName());
        }
        NameKey activeTab = CrazyAdvancementsAPI.getActiveTab(player);
        CrazyAdvancementsAPI.clearActiveTab(player);
        AdvancementsPacket packet = new AdvancementsPacket(player, false, advancements, names);
        packet.send();
        CrazyAdvancementsAPI.setActiveTab(player, activeTab);
    }

    public void updateProgress(Player player, Advancement ... advancements) {
        ArrayList<Advancement> advancementsList = new ArrayList<Advancement>();
        for (Advancement advancement : advancements) {
            boolean visible = advancement.getDisplay().isVisible(player, advancement);
            advancement.saveVisibilityStatus(player, visible);
            if (!visible) continue;
            advancementsList.add(advancement);
        }
        AdvancementsPacket packet = new AdvancementsPacket(player, false, advancementsList, null);
        packet.send();
    }

    public void updateVisibility(Player player) {
        for (Advancement advancement : this.getAdvancements()) {
            AdvancementsPacket packet;
            boolean visible;
            boolean visibleBefore = advancement.getVisibilityStatus(player);
            if (visibleBefore == (visible = advancement.getDisplay().isVisible(player, advancement))) continue;
            advancement.saveVisibilityStatus(player, visible);
            if (visible) {
                packet = new AdvancementsPacket(player, false, Arrays.asList(advancement), null);
                packet.send();
                continue;
            }
            packet = new AdvancementsPacket(player, false, null, Arrays.asList(advancement.getName()));
            packet.send();
        }
    }

    public GenericResult grantAdvancement(Player player, Advancement advancement) {
        if (advancement == null || player == null) {
            return null;
        }
        AdvancementProgress progress = advancement.getProgress(player);
        GenericResult result = progress.grant();
        if (result == GenericResult.CHANGED) {
            AdvancementReward reward;
            AdvancementGrantEvent event = new AdvancementGrantEvent(this, advancement, player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isShowToast() && player.getPlayer() != null) {
                advancement.displayToast(player);
            }
            if (event.isDisplayMessage()) {
                advancement.displayMessageToEverybody(player);
            }
            if ((reward = advancement.getReward()) != null) {
                reward.onGrant(player);
            }
            this.updateVisibility(player);
            this.updateProgress(player, advancement);
        }
        return result;
    }

    public GenericResult grantAdvancement(UUID uuid, Advancement advancement) {
        if (AdvancementManager.isOnline(uuid)) {
            return this.grantAdvancement(Bukkit.getPlayer((UUID)uuid), advancement);
        }
        AdvancementProgress progress = advancement.getProgress(uuid);
        return progress.grant();
    }

    public GenericResult revokeAdvancement(Player player, Advancement advancement) {
        AdvancementProgress progress = advancement.getProgress(player);
        GenericResult result = progress.revoke();
        if (result == GenericResult.CHANGED) {
            AdvancementRevokeEvent event = new AdvancementRevokeEvent(this, advancement, player);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.updateVisibility(player);
            this.updateProgress(player, advancement);
        }
        return result;
    }

    public GenericResult revokeAdvancement(UUID uuid, Advancement advancement) {
        if (AdvancementManager.isOnline(uuid)) {
            return this.revokeAdvancement(Bukkit.getPlayer((UUID)uuid), advancement);
        }
        AdvancementProgress progress = advancement.getProgress(uuid);
        return progress.revoke();
    }

    public GrantCriteriaResult grantCriteria(Player player, Advancement advancement, String ... criteria) {
        AdvancementProgress progress = advancement.getProgress(player);
        GrantCriteriaResult result = progress.grantCriteria(criteria);
        switch (result) {
            case COMPLETED: {
                AdvancementReward reward;
                AdvancementGrantEvent event = new AdvancementGrantEvent(this, advancement, player);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isShowToast() && player.getPlayer() != null) {
                    advancement.displayToast(player);
                }
                if (event.isDisplayMessage()) {
                    advancement.displayMessageToEverybody(player);
                }
                if ((reward = advancement.getReward()) != null) {
                    reward.onGrant(player);
                }
                this.updateVisibility(player);
            }
            case CHANGED: {
                this.updateProgress(player, advancement);
                break;
            }
        }
        return result;
    }

    public GrantCriteriaResult grantCriteria(UUID uuid, Advancement advancement, String ... criteria) {
        if (AdvancementManager.isOnline(uuid)) {
            return this.grantCriteria(Bukkit.getPlayer((UUID)uuid), advancement, criteria);
        }
        AdvancementProgress progress = advancement.getProgress(uuid);
        return progress.grantCriteria(criteria);
    }

    public GenericResult revokeCriteria(Player player, Advancement advancement, String ... criteria) {
        AdvancementProgress progress = advancement.getProgress(player);
        GenericResult result = progress.revokeCriteria(criteria);
        if (result == GenericResult.CHANGED) {
            AdvancementRevokeEvent event = new AdvancementRevokeEvent(this, advancement, player);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.updateVisibility(player);
            this.updateProgress(player, advancement);
        }
        return result;
    }

    public GenericResult revokeCriteria(UUID uuid, Advancement advancement, String ... criteria) {
        if (AdvancementManager.isOnline(uuid)) {
            return this.revokeCriteria(Bukkit.getPlayer((UUID)uuid), advancement, criteria);
        }
        AdvancementProgress progress = advancement.getProgress(uuid);
        return progress.revokeCriteria(criteria);
    }

    public SetCriteriaResult setCriteriaProgress(Player player, Advancement advancement, int criteriaProgress) {
        if (advancement.getCriteria().getType() == CriteriaType.NUMBER) {
            AdvancementProgress progress = advancement.getProgress(player);
            boolean doneBefore = progress.isDone();
            SetCriteriaResult result = progress.setCriteriaProgress(criteriaProgress);
            switch (result) {
                case COMPLETED: {
                    AdvancementReward reward;
                    AdvancementGrantEvent event = new AdvancementGrantEvent(this, advancement, player);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isShowToast() && player.getPlayer() != null) {
                        advancement.displayToast(player);
                    }
                    if (event.isDisplayMessage()) {
                        advancement.displayMessageToEverybody(player);
                    }
                    if ((reward = advancement.getReward()) != null) {
                        reward.onGrant(player);
                    }
                    this.updateVisibility(player);
                }
                case CHANGED: {
                    if (doneBefore) {
                        AdvancementRevokeEvent revokeEvent = new AdvancementRevokeEvent(this, advancement, player);
                        Bukkit.getPluginManager().callEvent((Event)revokeEvent);
                    }
                    this.updateProgress(player, advancement);
                    break;
                }
            }
            return result;
        }
        return SetCriteriaResult.INVALID;
    }

    public SetCriteriaResult setCriteriaProgress(UUID uuid, Advancement advancement, int criteriaProgress) {
        if (AdvancementManager.isOnline(uuid)) {
            return this.setCriteriaProgress(Bukkit.getPlayer((UUID)uuid), advancement, criteriaProgress);
        }
        if (advancement.getCriteria().getType() == CriteriaType.NUMBER) {
            AdvancementProgress progress = advancement.getProgress(uuid);
            return progress.setCriteriaProgress(criteriaProgress);
        }
        return SetCriteriaResult.INVALID;
    }

    public int getCriteriaProgress(Player player, Advancement advancement) {
        return advancement.getProgress(player).getCriteriaProgress();
    }

    public int getCriteriaProgress(UUID uuid, Advancement advancement) {
        return advancement.getProgress(uuid).getCriteriaProgress();
    }

    private String getSavePath(UUID uuid) {
        return CrazyAdvancementsAPI.getInstance().getDataFolder().getAbsolutePath() + File.separator + "saved_data" + File.separator + this.name.getNamespace() + File.separator + this.name.getKey() + File.separator + uuid + ".json";
    }

    private File getSaveFile(UUID uuid) {
        File file = new File(this.getSavePath(uuid));
        file.getParentFile().mkdirs();
        return file;
    }

    public SaveFile createNewSave(Player player, Advancement ... advancements) {
        return this.createNewSave(player.getUniqueId(), advancements);
    }

    public SaveFile createNewSave(UUID uuid, Advancement ... advancements) {
        List<Advancement> advancementsList = advancements.length == 0 ? this.getAdvancements() : Arrays.asList(advancements);
        ArrayList<ProgressData> progressData = new ArrayList<ProgressData>();
        ArrayList<CriteriaData> criteriaData = new ArrayList<CriteriaData>();
        for (Advancement advancement : advancementsList) {
            switch (advancement.getCriteria().getType()) {
                case NUMBER: {
                    progressData.add(new ProgressData(advancement.getName(), this.getCriteriaProgress(uuid, advancement)));
                    break;
                }
                case LIST: {
                    criteriaData.add(new CriteriaData(advancement.getName(), Lists.newArrayList(advancement.getProgress(uuid).getAwardedCriteria())));
                }
            }
        }
        return new SaveFile(progressData, criteriaData);
    }

    public void saveProgress(Player player, Advancement ... advancements) {
        this.saveProgress(player.getUniqueId(), advancements);
    }

    public void saveProgress(UUID uuid, Advancement ... advancements) {
        File file = this.getSaveFile(uuid);
        SaveFile saveFile = AdvancementManager.generateSaveFile(file);
        SaveFile newSaveFile = this.createNewSave(uuid, advancements);
        saveFile.merge(newSaveFile);
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else if (!file.isFile()) {
                if (file.listFiles().length > 0) {
                    throw new RuntimeException("Could not create Save File: A Non-Empty Folder with the File Name already exists: " + file.getName());
                }
                file.delete();
                file.createNewFile();
            }
            FileWriter w = new FileWriter(file);
            w.write(saveFile.toJson());
            w.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadProgress(Player player, Advancement ... advancements) {
        this.loadProgress(player.getUniqueId(), advancements);
    }

    public void loadProgress(UUID uuid, Advancement ... advancements) {
        File file = this.getSaveFile(uuid);
        SaveFile saveFile = AdvancementManager.generateSaveFile(file);
        this.loadProgress(uuid, saveFile, advancements);
    }

    public void loadProgress(Player player, SaveFile saveFile, Advancement ... advancements) {
        this.loadProgress(player.getUniqueId(), saveFile, advancements);
    }

    public void loadProgress(UUID uuid, SaveFile saveFile, Advancement ... advancements) {
        NameKey name;
        List<Advancement> advancementsList = advancements.length == 0 ? this.getAdvancements() : Arrays.asList(advancements);
        block0: for (ProgressData progressData : saveFile.getProgressData()) {
            name = progressData.getName();
            int progress = progressData.getProgress();
            for (Advancement advancement : advancementsList) {
                if (advancement.getCriteria().getType() != CriteriaType.NUMBER || !advancement.hasName(name)) continue;
                advancement.getProgress(uuid).setCriteriaProgress(progress);
                continue block0;
            }
        }
        block2: for (CriteriaData criteriaData : saveFile.getCriteriaData()) {
            name = criteriaData.getName();
            List<String> criteria = criteriaData.getCriteria();
            for (Advancement advancement : advancementsList) {
                if (advancement.getCriteria().getType() != CriteriaType.LIST || !advancement.hasName(name)) continue;
                advancement.getProgress(uuid).grantCriteria((String[])Iterables.toArray(criteria, String.class));
                continue block2;
            }
        }
    }

    public void unloadProgress(Player player, Advancement ... advancements) {
        List<Advancement> advancementsList = advancements.length == 0 ? this.getAdvancements() : Arrays.asList(advancements);
        for (Advancement advancement : advancementsList) {
            advancement.getProgress(player).revoke();
            this.updateProgress(player, advancements);
            advancement.unloadProgress(player);
        }
    }

    public void unloadProgress(UUID uuid, Advancement ... advancements) {
        List<Advancement> advancementsList = advancements.length == 0 ? this.getAdvancements() : Arrays.asList(advancements);
        for (Advancement advancement : advancementsList) {
            advancement.unloadProgress(uuid);
        }
    }

    public void unloadVisibilityStatus(Player player, Advancement ... advancements) {
        List<Advancement> advancementsList = advancements.length == 0 ? this.getAdvancements() : Arrays.asList(advancements);
        for (Advancement advancement : advancementsList) {
            advancement.unloadVisibilityStatus(player);
        }
    }

    public void unloadVisibilityStatus(UUID uuid, Advancement ... advancements) {
        List<Advancement> advancementsList = advancements.length == 0 ? this.getAdvancements() : Arrays.asList(advancements);
        for (Advancement advancement : advancementsList) {
            advancement.unloadVisibilityStatus(uuid);
        }
    }

    static {
        IBootstrap.dasBoot();
        accessibleManagers = new HashMap();
    }
}

