/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.packet;

import com.volmit.adapt.util.advancements.JSONMessage;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.ToastNotification;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class PacketConverter {
    private static final AdvancementRewards advancementRewards;
    private static final HashMap<NameKey, Float> smallestX;
    private static final HashMap<NameKey, Float> smallestY;

    public static void setSmallestX(NameKey tab, float smallestX) {
        PacketConverter.smallestX.put(tab, Float.valueOf(smallestX));
    }

    public static float getSmallestX(NameKey key) {
        return smallestX.containsKey(key) ? smallestX.get(key).floatValue() : 0.0f;
    }

    public static void setSmallestY(NameKey tab, float smallestY) {
        PacketConverter.smallestY.put(tab, Float.valueOf(smallestY));
    }

    public static float getSmallestY(NameKey key) {
        return smallestY.containsKey(key) ? smallestY.get(key).floatValue() : 0.0f;
    }

    public static float generateX(NameKey tab, float displayX) {
        return displayX - PacketConverter.getSmallestX(tab);
    }

    public static float generateY(NameKey tab, float displayY) {
        return displayY - PacketConverter.getSmallestY(tab);
    }

    public static net.minecraft.advancements.Advancement toNmsAdvancement(Advancement advancement) {
        boolean hasBackgroundTexture;
        AdvancementDisplay display = advancement.getDisplay();
        net.minecraft.world.item.ItemStack icon = CraftItemStack.asNMSCopy((ItemStack)display.getIcon());
        MinecraftKey backgroundTexture = null;
        boolean bl = hasBackgroundTexture = display.getBackgroundTexture() != null;
        if (hasBackgroundTexture) {
            backgroundTexture = new MinecraftKey(display.getBackgroundTexture());
        }
        float x = PacketConverter.generateX(advancement.getTab(), display.generateX());
        float y = PacketConverter.generateY(advancement.getTab(), display.generateY());
        net.minecraft.advancements.AdvancementDisplay advDisplay = new net.minecraft.advancements.AdvancementDisplay(icon, display.getTitle().getBaseComponent(), display.getDescription().getBaseComponent(), backgroundTexture, display.getFrame().getNMS(), false, false, advancement.hasFlag(AdvancementFlag.SEND_WITH_HIDDEN_BOOLEAN));
        advDisplay.a(x, y);
        net.minecraft.advancements.Advancement parent = advancement.getParent() == null ? null : PacketConverter.createDummy(advancement.getParent().getName());
        net.minecraft.advancements.Advancement adv = new net.minecraft.advancements.Advancement(advancement.getName().getMinecraftKey(), parent, advDisplay, advancementRewards, advancement.getCriteria().getCriteria(), advancement.getCriteria().getRequirements());
        return adv;
    }

    public static net.minecraft.advancements.Advancement toNmsToastAdvancement(ToastNotification notification) {
        net.minecraft.world.item.ItemStack icon = CraftItemStack.asNMSCopy((ItemStack)notification.getIcon());
        MinecraftKey backgroundTexture = null;
        net.minecraft.advancements.AdvancementDisplay advDisplay = new net.minecraft.advancements.AdvancementDisplay(icon, notification.getMessage().getBaseComponent(), new JSONMessage((BaseComponent)new TextComponent("Toast Notification")).getBaseComponent(), backgroundTexture, notification.getFrame().getNMS(), true, false, true);
        net.minecraft.advancements.Advancement adv = new net.minecraft.advancements.Advancement(ToastNotification.NOTIFICATION_NAME.getMinecraftKey(), null, advDisplay, advancementRewards, ToastNotification.NOTIFICATION_CRITERIA.getCriteria(), ToastNotification.NOTIFICATION_CRITERIA.getRequirements());
        return adv;
    }

    public static net.minecraft.advancements.Advancement createDummy(NameKey name) {
        net.minecraft.advancements.Advancement adv = new net.minecraft.advancements.Advancement(name.getMinecraftKey(), null, null, null, new HashMap(), new String[0][0]);
        return adv;
    }

    static {
        IBootstrap.dasBoot();
        advancementRewards = new AdvancementRewards(0, new MinecraftKey[0], new MinecraftKey[0], null);
        smallestX = new HashMap();
        smallestY = new HashMap();
    }
}

