/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.io;

import com.volmit.adapt.util.arcane.amulet.io.VoidOutputStream;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IO {
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final char[] hexArray;

    public static String decompress(String gz) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(Base64.getUrlDecoder().decode(gz));
        GZIPInputStream gzi = new GZIPInputStream(bin);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        IO.fullTransfer(gzi, boas, 256);
        gzi.close();
        return boas.toString();
    }

    public static byte[] sdecompress(String compressed) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(Base64.getUrlDecoder().decode(compressed));
        GZIPInputStream gzi = new GZIPInputStream(bin);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        IO.fullTransfer(gzi, boas, 256);
        gzi.close();
        return boas.toByteArray();
    }

    public static String encode(byte[] data) {
        return Base64.getUrlEncoder().encodeToString(data);
    }

    public static byte[] decode(String u) {
        return Base64.getUrlDecoder().decode(u);
    }

    public static String hash(String b) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256");
            return IO.bytesToHex(d.digest(b.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "\u00af\\_(\u30c4)_/\u00af";
        }
    }

    public static byte[] hashMD5(String b) {
        return IO.hash(b, "MD5");
    }

    public static byte[] hashSHA1(String b) {
        return IO.hash(b, "SHA-1");
    }

    public static byte[] hashSHA256(String b) {
        return IO.hash(b, "SHA-256");
    }

    public static byte[] hashSHA512(String b) {
        return IO.hash(b, "SHA-512");
    }

    public static byte[] hashSHA384(String b) {
        return IO.hash(b, "SHA-384");
    }

    public static byte[] hash(String b, String algo) {
        try {
            MessageDigest d = MessageDigest.getInstance(algo);
            return d.digest(b.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hash(File b) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256");
            DigestInputStream din = new DigestInputStream(new FileInputStream(b), d);
            IO.fullTransfer(din, new VoidOutputStream(), 8192);
            din.close();
            return IO.bytesToHex(din.getMessageDigest().digest());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "\u00af\\_(\u30c4)_/\u00af";
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars).toUpperCase();
    }

    public static int transfer(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int r = in.read(buffer);
        if (r != -1) {
            out.write(buffer, 0, r);
        }
        return r;
    }

    public static long transfer(InputStream in, OutputStream out, int targetBuffer, long totalSize) throws IOException {
        long total = totalSize;
        long wrote = 0L;
        byte[] buf = new byte[targetBuffer];
        int r = 0;
        while ((r = in.read(buf, 0, (int)(total < (long)targetBuffer ? total : (long)targetBuffer))) != -1) {
            out.write(buf, 0, r);
            wrote += (long)r;
            if ((total -= (long)r) > 0L) continue;
            break;
        }
        return wrote;
    }

    public static long fillTransfer(InputStream in, OutputStream out) throws IOException {
        return IO.fullTransfer(in, out, 8192);
    }

    public static void deleteUp(File f) {
        if (f.exists()) {
            f.delete();
            if (f.getParentFile().list().length == 0) {
                IO.deleteUp(f.getParentFile());
            }
        }
    }

    public static long fullTransfer(InputStream in, OutputStream out, int bufferSize) throws IOException {
        long wrote = 0L;
        byte[] buf = new byte[bufferSize];
        int r = 0;
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
            wrote += (long)r;
        }
        return wrote;
    }

    public static void delete(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            for (File i : f.listFiles()) {
                IO.delete(i);
            }
        }
        f.delete();
    }

    public static long size(File file) {
        long s = 0L;
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File i : file.listFiles()) {
                    s += IO.size(i);
                }
            } else {
                s += file.length();
            }
        }
        return s;
    }

    public static long count(File file) {
        long s = 0L;
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File i : file.listFiles()) {
                    s += IO.count(i);
                }
            } else {
                ++s;
            }
        }
        return s;
    }

    public static long transfer(InputStream in, OutputStream out, byte[] buf, int totalSize) throws IOException {
        long total = totalSize;
        long wrote = 0L;
        int r = 0;
        while ((r = in.read(buf, 0, (int)(total < (long)buf.length ? total : (long)buf.length))) != -1) {
            out.write(buf, 0, r);
            wrote += (long)r;
            if ((total -= (long)r) > 0L) continue;
            break;
        }
        return wrote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readEntry(File zipfile, String entryname, Consumer<InputStream> v) throws IOException {
        Throwable x = null;
        try (ZipFile file = new ZipFile(zipfile);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entryname.equals(entry.getName())) continue;
                InputStream in = file.getInputStream(entry);
                v.accept(in);
            }
        }
        if (x != null) {
            throw new IOException("Failed to read zip entry, however it has been closed safely.", x);
        }
    }

    public static void writeAll(File f, Object c) throws IOException {
        try {
            f.getParentFile().mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        pw.println(c.toString());
        pw.close();
    }

    public static void writeAll(File f, OutputStream c) throws IOException {
        f.getParentFile().mkdirs();
        FileInputStream in = new FileInputStream(f);
        IO.fullTransfer(in, c, 8192);
        in.close();
    }

    public static String readAll(File f) throws IOException {
        FileReader fr = new FileReader(f);
        BufferedReader bu = new BufferedReader(fr);
        StringBuilder c = new StringBuilder();
        String l = "";
        while ((l = bu.readLine()) != null) {
            c.append(l).append(LINE_SEPARATOR_UNIX);
        }
        bu.close();
        return c.toString();
    }

    public static String readAll(InputStream in) throws IOException {
        BufferedReader bu = new BufferedReader(new InputStreamReader(in));
        StringBuilder c = new StringBuilder();
        String l = "";
        while ((l = bu.readLine()) != null) {
            c.append(l).append(LINE_SEPARATOR_UNIX);
        }
        bu.close();
        return c.toString();
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).close();
        }
        file.setLastModified(System.currentTimeMillis());
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        IO.copyFile(srcFile, destFile, true);
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' exists but is a directory");
        }
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
        }
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + destFile + "' directory cannot be created");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException("Destination '" + destFile + "' exists but is read-only");
        }
        IO.doCopyFile(srcFile, destFile, preserveFileDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        try (FileInputStream input = new FileInputStream(srcFile);
             FileOutputStream output = new FileOutputStream(destFile);){
            IO.copy((InputStream)input, (OutputStream)output);
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void closeQuietly(Reader input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IO.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IO.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input, String encoding) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IO.copy(input, output, encoding);
        return output.toByteArray();
    }

    @Deprecated
    public static byte[] toByteArray(String input) {
        return input.getBytes();
    }

    public static char[] toCharArray(InputStream is) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IO.copy(is, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream is, String encoding) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IO.copy(is, output, encoding);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IO.copy(input, (Writer)sw);
        return sw.toCharArray();
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        IO.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        IO.copy(input, sw, encoding);
        return sw.toString();
    }

    public static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        IO.copy(input, (Writer)sw);
        return sw.toString();
    }

    @Deprecated
    public static String toString(byte[] input) {
        return new String(input);
    }

    @Deprecated
    public static String toString(byte[] input, String encoding) throws IOException {
        if (encoding == null) {
            return new String(input);
        }
        return new String(input, encoding);
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return IO.readLines(reader);
    }

    public static List<String> readLines(InputStream input, String encoding) throws IOException {
        if (encoding == null) {
            return IO.readLines(input);
        }
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return IO.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static InputStream toInputStream(String input) {
        byte[] bytes = input.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream toInputStream(String input, String encoding) throws IOException {
        byte[] bytes = encoding != null ? input.getBytes(encoding) : input.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(byte[] data, Writer output) throws IOException {
        if (data != null) {
            output.write(new String(data));
        }
    }

    public static void write(byte[] data, Writer output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IO.write(data, output);
            } else {
                output.write(new String(data, encoding));
            }
        }
    }

    public static void write(char[] data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(char[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(new String(data).getBytes());
        }
    }

    public static void write(char[] data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IO.write(data, output);
            } else {
                output.write(new String(data).getBytes(encoding));
            }
        }
    }

    public static void write(String data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(String data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.getBytes());
        }
    }

    public static void write(String data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IO.write(data, output);
            } else {
                output.write(data.getBytes(encoding));
            }
        }
    }

    public static void write(StringBuffer data, Writer output) throws IOException {
        if (data != null) {
            output.write(data.toString());
        }
    }

    public static void write(StringBuffer data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.toString().getBytes());
        }
    }

    public static void write(StringBuffer data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IO.write(data, output);
            } else {
                output.write(data.toString().getBytes(encoding));
            }
        }
    }

    public static void writeLines(Collection<String> lines, String lineEnding, OutputStream output) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        for (String line : lines) {
            if (line != null) {
                output.write(line.toString().getBytes());
            }
            output.write(lineEnding.getBytes());
        }
    }

    public static void writeLines(Collection<String> lines, String lineEnding, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IO.writeLines(lines, lineEnding, output);
        } else {
            if (lines == null) {
                return;
            }
            if (lineEnding == null) {
                lineEnding = LINE_SEPARATOR;
            }
            for (String line : lines) {
                if (line != null) {
                    output.write(line.toString().getBytes(encoding));
                }
                output.write(lineEnding.getBytes(encoding));
            }
        }
    }

    public static void writeLines(Collection<String> lines, String lineEnding, Writer writer) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        for (String line : lines) {
            if (line != null) {
                writer.write(line.toString());
            }
            writer.write(lineEnding);
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IO.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IO.copy((Reader)in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IO.copy(input, output);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            IO.copy((Reader)in, output);
        }
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IO.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IO.copy(input, (Writer)out);
        out.flush();
    }

    public static void copy(Reader input, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IO.copy(input, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, encoding);
            IO.copy(input, (Writer)out);
            out.flush();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedReader)) {
            input1 = new BufferedReader(input1);
        }
        if (!(input2 instanceof BufferedReader)) {
            input2 = new BufferedReader(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    static {
        IBootstrap.dasBoot();
        DIR_SEPARATOR = File.separatorChar;
        hexArray = "0123456789ABCDEF".toCharArray();
        StringWriter buf = new StringWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
    }
}

