/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.AbstractLongIterator;
import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LongRange
extends NumberRange<Long, LongRange> {
    public LongRange(Long left, Long right) {
        this(left, right, 1L, true, true, false);
    }

    public LongRange(Long left, Long right, long lStep, boolean leftClosed, boolean rightClosed, boolean reverse) {
        super(left, right, lStep, leftClosed, rightClosed, reverse);
        if (lStep <= 0L) {
            throw new IllegalArgumentException("The step must be greater than 0: " + lStep);
        }
    }

    @Override
    public Iterator<Long> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Long> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Long getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        long value = (Long)this.getLeftEndpoint() + (Long)this.getStep() * (long)iStepIndex;
        if (this.isRightClosed() ? value <= (Long)this.getRightEndpoint() : value < (Long)this.getRightEndpoint()) {
            return value;
        }
        return null;
    }

    public LongRange unaryMinus() {
        Long left = (Long)this.getLeftEndpoint();
        Long right = (Long)this.getRightEndpoint();
        if (this.isReversed()) {
            return new LongRange(left, right, (Long)this.getStep(), true, true, false);
        }
        return new LongRange(right, left, (Long)this.getStep(), true, true, true);
    }

    @Override
    public Long getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        long value = (Long)this.getRightEndpoint() - (Long)this.getStep() * (long)iStepIndex;
        if (this.isLeftClosed() ? value >= (Long)this.getLeftEndpoint() : value > (Long)this.getLeftEndpoint()) {
            return value;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    public class ForwardIterator
    extends AbstractLongIterator {
        private long _csr;

        public ForwardIterator() {
            this._csr = (Long)LongRange.this.getLeftEndpoint();
            if (!LongRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Long)LongRange.this.getRightEndpoint() || LongRange.this.isRightClosed() && this._csr == (Long)LongRange.this.getRightEndpoint();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (this._csr > (Long)LongRange.this.getRightEndpoint() || !LongRange.this.isRightClosed() && this._csr == (Long)LongRange.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            long ret = this._csr;
            this._csr += ((Long)LongRange.this.getStep()).longValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    extends AbstractLongIterator {
        private long _csr;

        public ReverseIterator() {
            this._csr = (Long)LongRange.this.getRightEndpoint();
            if (!LongRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Long)LongRange.this.getLeftEndpoint() || LongRange.this.isLeftClosed() && this._csr == (Long)LongRange.this.getLeftEndpoint();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (this._csr < (Long)LongRange.this.getLeftEndpoint() || !LongRange.this.isLeftClosed() && this._csr == (Long)LongRange.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            long ret = this._csr;
            this._csr -= ((Long)LongRange.this.getStep()).longValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

