/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse;

import com.strobel.decompiler.Decompiler;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.volmit.adapt.util.arcane.curse.model.CursedComponent;
import com.volmit.adapt.util.arcane.curse.model.CursedConstructor;
import com.volmit.adapt.util.arcane.curse.model.CursedContext;
import com.volmit.adapt.util.arcane.curse.model.CursedField;
import com.volmit.adapt.util.arcane.curse.model.CursedMethod;
import com.volmit.adapt.util.arcane.curse.util.JarLoader;
import com.volmit.adapt.util.arcane.curse.util.poet.JavaFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import sun.misc.Unsafe;

public class Curse {
    public static Stream<CursedMethod> withMethod(Class<?> sourceJarClass, String name, Class<?> ... parameters) {
        try {
            return new JarLoader(sourceJarClass).all().filter(i -> Curse.on(i).optionalMethod(name, parameters).isPresent()).map(i -> Curse.on(i).method(name, parameters));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void stop(Thread thread) {
        thread.interrupt();
        thread.suspend();
        thread.stop();
    }

    public static void resume(Thread thread) {
        thread.resume();
    }

    public static void pause(Thread thread) {
        thread.suspend();
    }

    public static Unsafe unsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void unpark(Thread thread) {
        Curse.unsafe().unpark(thread);
    }

    public static void park(double milliseconds) {
        if (milliseconds == 0.0) {
            Curse.unsafe().park(true, 0L);
        } else if (milliseconds > 999.0 || (double)((long)milliseconds) == milliseconds) {
            Curse.unsafe().park(true, System.currentTimeMillis() + (long)milliseconds);
        } else {
            long m = (long)(milliseconds * 1000000.0);
            Curse.unsafe().park(false, m);
        }
    }

    public static String decompile(Class<?> clazz) {
        try {
            if (clazz.getCanonicalName() == null) {
                return "err: null canonical";
            }
            StringWriter s = new StringWriter();
            Decompiler.decompile((String)clazz.getCanonicalName().replaceAll("\\Q.\\E", "/"), (ITextOutput)new PlainTextOutput((Writer)s), (DecompilerSettings)DecompilerSettings.javaDefaults());
            return s.toString();
        }
        catch (Throwable ignored) {
            return "err: " + ignored.getClass().getCanonicalName() + " " + ignored.getMessage();
        }
    }

    public static Stream<CursedConstructor> withConstructor(Class<?> sourceJarClass, Class<?> ... parameters) {
        try {
            return new JarLoader(sourceJarClass).all().filter(i -> Curse.on(i).optionalConstructor(parameters).isPresent()).map(i -> Curse.on(i).constructor(parameters));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File temp(String ... filePath) {
        File f = new File(System.getProperty("java.io.tmpdir"), String.join((CharSequence)File.separator, filePath));
        f.getParentFile().mkdirs();
        return f;
    }

    public static Stream<CursedField> withField(Class<?> sourceJarClass, String name) {
        try {
            return new JarLoader(sourceJarClass).all().filter(i -> Curse.on(i).optionalField(name).isPresent()).map(i -> Curse.on(i).field(name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedField> withField(Class<?> sourceJarClass, String name, Class<?> type) {
        try {
            return new JarLoader(sourceJarClass).all().filter(i -> {
                Optional<CursedField> f = Curse.on(i).optionalField(name);
                return f.isPresent() && f.get().field().getType().equals(type);
            }).map(i -> Curse.on(i).field(name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadOrInstallClass(String canonical, String dependency, String repository) {
        try {
            return Class.forName(canonical);
        }
        catch (Throwable e) {
            return Curse.installDependency(dependency, repository).filter(i -> i.getCanonicalName().equals(canonical)).findFirst().orElseThrow();
        }
    }

    public static Stream<Class<?>> installDependency(String dependency, String repository) {
        try {
            File file = Curse.downloadCachedFile(Curse.getJarDependencyUrl(dependency, repository), "jar").get();
            return Curse.load(file);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJarDependencyUrl(String dependency, String repository) {
        String[] c = dependency.split("\\Q:\\E");
        return repository + "/" + c[0].replaceAll("\\Q.\\E", "/") + "/" + c[1] + "/" + c[2] + "/" + c[1] + "-" + c[2] + ".jar";
    }

    public static Future<File> downloadCachedFile(String url, String ext) {
        File f = Curse.temp("dlc", UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)) + "." + ext);
        if (f.exists()) {
            return CompletableFuture.completedFuture(f);
        }
        return Curse.downloadFile(url, f);
    }

    public static Future<File> downloadFile(String url, File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(url).openStream());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                fileOutputStream.close();
                return file;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Class<?> compile(JavaFile file) throws Throwable {
        return Curse.compile(file.packageName + "." + file.typeSpec.name, file.toString());
    }

    public static Stream<Class<?>> containingSource(Class<?> baseJar, String sourceCodeSnippet) {
        return Curse.all(baseJar).map(i -> i.type()).filter(i -> Curse.decompile(i).contains(sourceCodeSnippet)).map(i -> i);
    }

    public static Class<?> compile(String canonicalName, String sourceCode) throws Throwable {
        File sourceFolder = Curse.temp("compile", UUID.randomUUID().toString(), "src");
        File sourceFile = new File(sourceFolder, canonicalName.replaceAll("\\Q.\\E", "/") + ".java");
        sourceFile.getParentFile().mkdirs();
        Files.writeString(sourceFile.toPath(), (CharSequence)sourceCode, new OpenOption[0]);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        compiler.run(null, null, null, sourceFile.getPath());
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{sourceFolder.toURI().toURL()});
        return classLoader.loadClass(canonicalName);
    }

    public static Stream<CursedComponent> all(Class<?> sourceJarClass) {
        try {
            return new JarLoader(sourceJarClass).all().filter(Objects::nonNull).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void shove(Object source, Object destination) {
        Curse.implode(destination, Curse.explode(source));
    }

    public static void implode(Object object, Map<String, Object> map) {
        CursedComponent component = Curse.on(object);
        for (String i : map.keySet()) {
            component.set(i, map.get(i));
        }
    }

    public static Map<String, Object> explode(Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Curse.on(object).instanceFields().forEach(i -> {
            Object o = i.get();
            if (o != null) {
                map.put(i.field().getName(), o);
            }
        });
        return map;
    }

    public static Stream<Class<?>> load(File jarOrFolder) {
        return Curse.load(Curse.class.getClassLoader(), jarOrFolder);
    }

    public static Stream<Class<?>> load(ClassLoader parentClassLoader, File jarOrFolder) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{jarOrFolder.toURI().toURL()}, parentClassLoader);
            return new JarLoader(loader, jarOrFolder).all();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> where(Class<?> sourceJarClass, Predicate<Class<?>> c) {
        try {
            return new JarLoader(sourceJarClass).all().map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> whereInPackage(Class<?> sourceJarClass, Predicate<Class<?>> c, String pkg) {
        try {
            return new JarLoader(sourceJarClass).inPackageNested(pkg).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> implemented(Class<?> sourceJarClass, Class<?> interfaceOrClass) {
        try {
            return new JarLoader(sourceJarClass).all(interfaceOrClass).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> implementedInPackage(Class<?> sourceJarClass, Class<?> interfaceOrClass, String pkg) {
        try {
            return new JarLoader(sourceJarClass).inPackageNested(pkg, interfaceOrClass).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> annotated(Class<?> sourceJarClass, Class<? extends Annotation> annotation) {
        try {
            return new JarLoader(sourceJarClass).all().filter(i -> i.isAnnotationPresent(annotation)).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> annotatedName(Class<?> sourceJarClass, String annotation) {
        try {
            return new JarLoader(sourceJarClass).all().filter(i -> {
                for (Annotation a2 : i.getDeclaredAnnotations()) {
                    if (!a2.annotationType().getSimpleName().equals(annotation)) continue;
                    return true;
                }
                for (Annotation a2 : i.getAnnotations()) {
                    if (!a2.annotationType().getSimpleName().equals(annotation)) continue;
                    return true;
                }
                return false;
            }).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<CursedComponent> annotatedInPackage(Class<?> sourceJarClass, Class<? extends Annotation> annotation, String pkg) {
        try {
            return new JarLoader(sourceJarClass).inPackageNested(pkg).filter(i -> i.isAnnotationPresent(annotation)).map(Curse::on);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CursedComponent on(Object instance) {
        return new CursedComponent(new CursedContext().instance(instance).type(instance.getClass()));
    }

    public static CursedComponent on(Class<?> clazz) {
        return new CursedComponent(new CursedContext().type(clazz));
    }
}

