/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util;

import com.volmit.adapt.util.arcane.curse.Curse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarLoader {
    private final Map<String, Supplier<Class<?>>> classCache = new HashMap();

    public static JarLoader from(Class<?> jarClass) throws IOException {
        return new JarLoader(jarClass);
    }

    public static void allFiles(File folder, Consumer<File> f) {
        if (folder.isDirectory()) {
            for (File i : folder.listFiles()) {
                JarLoader.allFiles(i, f);
            }
        } else {
            f.accept(folder);
        }
    }

    public JarLoader(File ... jarFiles) throws IOException {
        this(Curse.class.getClassLoader(), jarFiles);
    }

    public JarLoader(ClassLoader loader, File ... jarFiles) throws IOException {
        ArrayList<File> jars = new ArrayList<File>(List.of(jarFiles));
        for (File i : jars) {
            if (i.isDirectory()) {
                JarLoader.allFiles(i, j -> {
                    String jarPath = Paths.get(i.getPath(), new String[0]).relativize(Paths.get(j.getPath(), new String[0])).toString();
                    String c = jarPath.replace(".class", "").replaceAll("\\Q" + File.separator + "\\E", ".");
                    this.classCache.put(c, () -> {
                        try {
                            return Class.forName(c, true, loader);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    });
                });
                continue;
            }
            FileInputStream fin = new FileInputStream(i);
            ZipInputStream zip = new ZipInputStream(fin);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class") && !entry.getName().contains("$")) {
                    String c = entry.getName().replaceAll("\\Q" + File.separator + "\\E", ".").replace(".class", "");
                    this.classCache.put(c, () -> {
                        try {
                            return Class.forName(c, true, loader);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    });
                }
                entry = zip.getNextEntry();
            }
            zip.close();
        }
    }

    public JarLoader(Class<?> ... baseClasses) throws IOException {
        this((File[])Arrays.stream(baseClasses).map(i -> new File(i.getProtectionDomain().getCodeSource().getLocation().getFile())).toArray(File[]::new));
    }

    public Stream<Class<?>> all() {
        return this.classCache.keySet().parallelStream().map(i -> this.classCache.get(i).get()).filter(Objects::nonNull).map(i -> i);
    }

    public Stream<Class<?>> all(Class<?> superType) {
        return this.all().filter(i -> i.isAssignableFrom(superType) || superType.isAssignableFrom((Class<?>)i)).filter(i -> !i.equals(superType));
    }

    public Stream<Class<?>> inPackageNested(String superPackage, Class<?> superType) {
        return this.classCache.keySet().parallelStream().filter(i -> i.startsWith(superPackage)).map(i -> this.classCache.get(i).get()).filter(Objects::nonNull).map(i -> i).filter(i -> !i.equals(superType)).filter(superType::isAssignableFrom).map(i -> i);
    }

    public Stream<Class<?>> inPackageSpecifically(String superPackage, Class<?> superType) {
        return this.classCache.keySet().parallelStream().filter(i -> i.startsWith(superPackage) && this.removeLast(this.splitAbs((String)i, ".")).equals(this.splitAbs(superPackage, "."))).map(i -> this.classCache.get(i).get()).filter(Objects::nonNull).map(i -> i).filter(i -> !i.equals(superType)).filter(superType::isAssignableFrom).map(i -> i);
    }

    public Stream<Class<?>> inPackageNested(String superPackage) {
        return this.classCache.keySet().parallelStream().filter(i -> i.startsWith(superPackage)).map(i -> this.classCache.get(i).get()).filter(Objects::nonNull).map(i -> i);
    }

    public Stream<Class<?>> inPackageSpecifically(String superPackage) {
        return this.classCache.keySet().parallelStream().filter(i -> i.startsWith(superPackage) && this.removeLast(this.splitAbs((String)i, ".")).equals(this.splitAbs(superPackage, "."))).map(i -> this.classCache.get(i).get()).filter(Objects::nonNull).map(i -> i);
    }

    private List<String> splitAbs(String s, String find) {
        return Arrays.asList(s.split("\\Q" + find + "\\E"));
    }

    private List<String> removeLast(List<String> s) {
        s.remove(s.size() - 1);
        return s;
    }
}

