/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.multiburst;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class BurstExecutor {
    private final ExecutorService executor;
    private final List<Future<?>> futures;
    private boolean multicore = true;

    public BurstExecutor(ExecutorService executor, int burstSizeEstimate) {
        this.executor = executor;
        this.futures = new ArrayList(burstSizeEstimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> queue(Runnable r) {
        if (!this.multicore) {
            r.run();
            return CompletableFuture.completedFuture(null);
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            Future<?> c = this.executor.submit(r);
            this.futures.add(c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BurstExecutor queue(List<Runnable> r) {
        if (!this.multicore) {
            for (Runnable i : new ArrayList<Runnable>(r)) {
                i.run();
            }
            return this;
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            for (Runnable i : new ArrayList<Runnable>(r)) {
                this.queue(i);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BurstExecutor queue(Runnable[] r) {
        if (!this.multicore) {
            for (Runnable i : r) {
                i.run();
            }
            return this;
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            for (Runnable i : r) {
                this.queue(i);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        if (!this.multicore) {
            return;
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            if (this.futures.isEmpty()) {
                return;
            }
            try {
                for (Future<?> i : this.futures) {
                    i.get();
                }
                this.futures.clear();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void setMulticore(boolean multicore) {
        this.multicore = multicore;
    }
}

