/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.multiburst;

import com.volmit.adapt.util.arcane.multiburst.BurstExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MultiBurst {
    public static final MultiBurst burst = new MultiBurst();
    private final AtomicLong last;
    private final String name;
    private final int priority;
    private ExecutorService service;

    public MultiBurst() {
        this("Iris", 1);
    }

    public MultiBurst(String name, int priority) {
        this.name = name;
        this.priority = priority;
        this.last = new AtomicLong(System.currentTimeMillis());
    }

    private synchronized ExecutorService getService() {
        this.last.set(System.currentTimeMillis());
        if (this.service == null || this.service.isShutdown()) {
            this.service = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
                int m = 0;

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    worker.setPriority(MultiBurst.this.priority);
                    worker.setName(MultiBurst.this.name + " " + ++this.m);
                    return worker;
                }
            }, (t, e) -> e.printStackTrace(), true);
        }
        return this.service;
    }

    public void burst(Runnable ... r) {
        this.burst(r.length).queue(r).complete();
    }

    public void burst(boolean multicore, Runnable ... r) {
        if (multicore) {
            this.burst(r);
        } else {
            this.sync(r);
        }
    }

    public void burst(List<Runnable> r) {
        this.burst(r.size()).queue(r).complete();
    }

    public void burst(boolean multicore, List<Runnable> r) {
        if (multicore) {
            this.burst(r);
        } else {
            this.sync(r);
        }
    }

    private void sync(List<Runnable> r) {
        for (Runnable i : new ArrayList<Runnable>(r)) {
            i.run();
        }
    }

    public void sync(Runnable ... r) {
        for (Runnable i : r) {
            i.run();
        }
    }

    public BurstExecutor burst(int estimate) {
        return new BurstExecutor(this.getService(), estimate);
    }

    public BurstExecutor burst() {
        return this.burst(16);
    }

    public BurstExecutor burst(boolean multicore) {
        BurstExecutor b = this.burst();
        b.setMulticore(multicore);
        return b;
    }

    public <T> Future<T> lazySubmit(Callable<T> o) {
        return this.getService().submit(o);
    }

    public void lazy(Runnable o) {
        this.getService().execute(o);
    }

    public Future<?> future(Runnable o) {
        return this.getService().submit(o);
    }

    public Future<?> complete(Runnable o) {
        return this.getService().submit(o);
    }

    public <T> Future<T> completeValue(Callable<T> o) {
        return this.getService().submit(o);
    }

    public void close() {
        if (this.service != null) {
            this.service.shutdown();
            long m = System.currentTimeMillis();
            try {
                while (!this.service.awaitTermination(1L, TimeUnit.SECONDS)) {
                    if (System.currentTimeMillis() - m <= 7000L) continue;
                    try {
                        this.service.shutdownNow();
                    }
                    catch (Throwable throwable) {}
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

