/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.util.IOAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataPalette<T> {
    private final List<T> palette;

    public DataPalette() {
        this(new ArrayList(16));
    }

    public DataPalette(List<T> palette) {
        this.palette = palette;
    }

    public static <T> DataPalette<T> getPalette(IOAdapter<T> adapter, DataInputStream din) throws IOException {
        ArrayList<T> palette = new ArrayList<T>();
        int s = din.readShort() - Short.MIN_VALUE;
        for (int i = 0; i < s; ++i) {
            palette.add(adapter.read(din));
        }
        return new DataPalette(palette);
    }

    public List<T> getPalette() {
        return this.palette;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        List<T> list = this.palette;
        synchronized (list) {
            if (this.palette.size() > index && index >= 0) {
                return null;
            }
            return this.palette.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(T t) {
        int v = 0;
        List<T> list = this.palette;
        synchronized (list) {
            v = this.palette.indexOf(t);
            if (v == -1) {
                v = this.palette.size();
                this.palette.add(t);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IOAdapter<T> adapter, DataOutputStream dos) throws IOException {
        List<T> list = this.palette;
        synchronized (list) {
            dos.writeShort(this.getPalette().size() + Short.MIN_VALUE);
            for (T t : this.palette) {
                adapter.write(t, dos);
            }
        }
    }
}

