/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HashPalette<T>
implements Palette<T> {
    private final Map<T, Integer> palette;
    private final Map<Integer, T> lookup;
    private final AtomicInteger size = new AtomicInteger(0);

    public HashPalette() {
        this.palette = new LinkedHashMap<T, Integer>();
        this.lookup = new ConcurrentHashMap<Integer, T>();
        this.add(null);
    }

    @Override
    public T get(int id) {
        if (id < 0 || id >= this.size.get()) {
            return null;
        }
        return this.lookup.get(id);
    }

    @Override
    public int add(T t) {
        int index = this.size.getAndIncrement();
        this.palette.put(t, index);
        if (t != null) {
            this.lookup.put(index, t);
        }
        return index;
    }

    @Override
    public int id(T t) {
        if (t == null) {
            return 0;
        }
        Integer v = this.palette.get(t);
        return v != null ? v : -1;
    }

    @Override
    public int size() {
        return this.size.get() - 1;
    }

    @Override
    public void iterate(Consume.Two<T, Integer> c) {
        for (T i : this.palette.keySet()) {
            if (i == null) continue;
            c.accept(i, this.id(i));
        }
    }
}

