/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class LinearPalette<T>
implements Palette<T> {
    private final AtomicReference<AtomicReferenceArray<T>> palette;
    private final AtomicInteger size = new AtomicInteger(0);

    public LinearPalette(int initialSize) {
        this.palette = new AtomicReference(new AtomicReferenceArray(initialSize));
        this.palette.get().set(this.size.getAndIncrement(), null);
    }

    @Override
    public T get(int id) {
        if (id < 0 || id >= this.size.get()) {
            return null;
        }
        return this.palette.get().get(id);
    }

    @Override
    public int add(T t) {
        int index = this.size.getAndIncrement();
        this.grow(index + 1);
        this.palette.get().set(index, t);
        return index;
    }

    private void grow(int newLength) {
        if (newLength > this.palette.get().length()) {
            AtomicReferenceArray<T> a2 = new AtomicReferenceArray<T>(newLength + this.size.get());
            for (int i = 0; i < this.palette.get().length(); ++i) {
                a2.set(i, this.palette.get().get(i));
            }
            this.palette.set(a2);
        }
    }

    @Override
    public int id(T t) {
        if (t == null) {
            return 0;
        }
        for (int i = 1; i < this.size() + 1; ++i) {
            if (!t.equals(this.palette.get().get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size.get() - 1;
    }

    @Override
    public void iterate(Consume.Two<T, Integer> c) {
        for (int i = 1; i < this.size() + 1; ++i) {
            c.accept(this.palette.get().get(i), i);
        }
    }
}

