/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final AtomicReferenceArray<T> data;

    public AtomicHunk(int w, int h, int d) {
        super(w, h, d);
        this.data = new AtomicReferenceArray(w * h * d);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int x, int y, int z, T t) {
        this.data.set(this.index(x, y, z), t);
    }

    @Override
    public T getRaw(int x, int y, int z) {
        return this.data.get(this.index(x, y, z));
    }

    private int index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    public AtomicReferenceArray<T> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomicHunk)) {
            return false;
        }
        AtomicHunk other = (AtomicHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicReferenceArray<T> this$data = this.getData();
        AtomicReferenceArray<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AtomicHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicReferenceArray<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

