/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicLongHunk
extends StorageHunk<Long>
implements Hunk<Long> {
    private final AtomicLongArray data;

    public AtomicLongHunk(int w, int h, int d) {
        super(w, h, d);
        this.data = new AtomicLongArray(w * h * d);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int x, int y, int z, Long t) {
        this.data.set(this.index(x, y, z), t);
    }

    @Override
    public Long getRaw(int x, int y, int z) {
        return this.data.get(this.index(x, y, z));
    }

    private int index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    public AtomicLongArray getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicLongHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomicLongHunk)) {
            return false;
        }
        AtomicLongHunk other = (AtomicLongHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicLongArray this$data = this.getData();
        AtomicLongArray other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AtomicLongHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicLongArray $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

